/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.event.events.LogEvent;
import java.util.function.Consumer;
import org.gradle.api.logging.Logger;

class LogEventHandler
implements Consumer<LogEvent> {
    private final Logger logger;

    LogEventHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void accept(LogEvent logEvent) {
        switch (logEvent.getLevel()) {
            case LIFECYCLE: {
                this.logger.lifecycle(logEvent.getMessage());
                break;
            }
            case DEBUG: {
                this.logger.debug(logEvent.getMessage());
                break;
            }
            case ERROR: {
                this.logger.error(logEvent.getMessage());
                break;
            }
            case INFO: {
                this.logger.info(logEvent.getMessage());
                break;
            }
            case WARN: {
                this.logger.warn("warning: " + logEvent.getMessage());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown LogEvent.Level: " + (Object)((Object)logEvent.getLevel()));
            }
        }
    }
}

