/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.gradle.BuildDockerTask;
import com.google.cloud.tools.jib.gradle.BuildImageTask;
import com.google.cloud.tools.jib.gradle.BuildTarTask;
import com.google.cloud.tools.jib.gradle.DockerContextTask;
import com.google.cloud.tools.jib.gradle.FilesTask;
import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.util.GradleVersion;

public class JibPlugin
implements Plugin<Project> {
    @VisibleForTesting
    static final GradleVersion GRADLE_MIN_VERSION = GradleVersion.version((String)"4.6");
    @VisibleForTesting
    static final String JIB_EXTENSION_NAME = "jib";
    @VisibleForTesting
    static final String BUILD_IMAGE_TASK_NAME = "jib";
    @VisibleForTesting
    static final String BUILD_TAR_TASK_NAME = "jibBuildTar";
    @VisibleForTesting
    static final String BUILD_DOCKER_TASK_NAME = "jibDockerBuild";
    @VisibleForTesting
    static final String DOCKER_CONTEXT_TASK_NAME = "jibExportDockerContext";
    @VisibleForTesting
    static final String FILES_TASK_NAME = "_jibSkaffoldFiles";

    @VisibleForTesting
    static List<Project> getProjectDependencies(Project project) {
        return project.getConfigurations().stream().map(Configuration::getDependencies).flatMap(Collection::stream).filter(ProjectDependency.class::isInstance).map(ProjectDependency.class::cast).map(ProjectDependency::getDependencyProject).collect(Collectors.toList());
    }

    private static void checkGradleVersion() {
        if (GRADLE_MIN_VERSION.compareTo(GradleVersion.current()) > 0) {
            throw new GradleException("Detected " + GradleVersion.current() + ", but jib requires " + GRADLE_MIN_VERSION + " or higher. You can upgrade by running 'gradle wrapper --gradle-version=" + GRADLE_MIN_VERSION.getVersion() + "'.");
        }
    }

    public void apply(Project project) {
        JibPlugin.checkGradleVersion();
        JibExtension jibExtension = (JibExtension)project.getExtensions().create("jib", JibExtension.class, new Object[]{project});
        BuildImageTask buildImageTask = ((BuildImageTask)project.getTasks().create("jib", BuildImageTask.class)).setJibExtension(jibExtension);
        DockerContextTask dockerContextTask = ((DockerContextTask)project.getTasks().create(DOCKER_CONTEXT_TASK_NAME, DockerContextTask.class)).setJibExtension(jibExtension);
        BuildDockerTask buildDockerTask = ((BuildDockerTask)project.getTasks().create(BUILD_DOCKER_TASK_NAME, BuildDockerTask.class)).setJibExtension(jibExtension);
        BuildTarTask buildTarTask = ((BuildTarTask)project.getTasks().create(BUILD_TAR_TASK_NAME, BuildTarTask.class)).setJibExtension(jibExtension);
        FilesTask filesTask = ((FilesTask)project.getTasks().create(FILES_TASK_NAME, FilesTask.class)).setJibExtension(jibExtension);
        project.afterEvaluate(arg_0 -> JibPlugin.lambda$apply$1(buildImageTask, dockerContextTask, buildDockerTask, buildTarTask, (Task)filesTask, arg_0));
    }

    private static /* synthetic */ void lambda$apply$1(Task buildImageTask, Task dockerContextTask, Task buildDockerTask, Task buildTarTask, Task filesTask, Project projectAfterEvaluation) {
        try {
            Task classesTask = projectAfterEvaluation.getTasks().getByPath("classes");
            buildImageTask.dependsOn(new Object[]{classesTask});
            dockerContextTask.dependsOn(new Object[]{classesTask});
            buildDockerTask.dependsOn(new Object[]{classesTask});
            buildTarTask.dependsOn(new Object[]{classesTask});
            filesTask.dependsOn(new Object[]{classesTask});
            List<Project> computedDependencies = JibPlugin.getProjectDependencies(projectAfterEvaluation);
            for (Project dependencyProject : computedDependencies) {
                dependencyProject.getPlugins().withType(BasePlugin.class, unused -> {
                    Task assembleTask = dependencyProject.getTasks().getByPath("assemble");
                    buildImageTask.dependsOn(new Object[]{assembleTask});
                    dockerContextTask.dependsOn(new Object[]{assembleTask});
                    buildDockerTask.dependsOn(new Object[]{assembleTask});
                    buildTarTask.dependsOn(new Object[]{assembleTask});
                    filesTask.dependsOn(new Object[]{assembleTask});
                });
            }
        }
        catch (UnknownTaskException ex) {
            throw new GradleException("Could not find task 'classes' on project " + projectAfterEvaluation.getDisplayName() + " - perhaps you did not apply the 'java' plugin?", (Throwable)ex);
        }
    }
}

