/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.JibLogger;
import com.google.cloud.tools.jib.event.DefaultEventEmitter;
import com.google.cloud.tools.jib.event.EventEmitter;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.event.JibEventType;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.frontend.JavaLayerConfigurations;
import com.google.cloud.tools.jib.gradle.GradleJibLogger;
import com.google.cloud.tools.jib.gradle.GradleLayerConfigurations;
import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.cloud.tools.jib.gradle.LogEventHandler;
import com.google.cloud.tools.jib.plugins.common.MainClassInferenceException;
import com.google.cloud.tools.jib.plugins.common.MainClassResolver;
import com.google.cloud.tools.jib.plugins.common.ProjectProperties;
import com.google.cloud.tools.jib.plugins.common.TimerEventHandler;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.tasks.bundling.War;
import org.gradle.jvm.tasks.Jar;

class GradleProjectProperties
implements ProjectProperties {
    static final String TOOL_NAME = "jib-gradle-plugin";
    private static final String PLUGIN_NAME = "jib";
    private static final String JAR_PLUGIN_NAME = "'jar' task";
    private final Project project;
    private final EventEmitter eventEmitter;
    private final GradleJibLogger gradleJibLogger;
    private final JavaLayerConfigurations javaLayerConfigurations;

    static GradleProjectProperties getForProject(Project project, Logger logger, Path extraDirectory, AbsoluteUnixPath appRoot) {
        try {
            return new GradleProjectProperties(project, GradleProjectProperties.makeEventEmitter(logger), new GradleJibLogger(logger), GradleLayerConfigurations.getForProject(project, logger, extraDirectory, appRoot));
        }
        catch (IOException ex) {
            throw new GradleException("Obtaining project build output files failed", (Throwable)ex);
        }
    }

    private static EventEmitter makeEventEmitter(Logger logger) {
        return new DefaultEventEmitter(new EventHandlers().add(JibEventType.LOGGING, new LogEventHandler(logger)).add(JibEventType.TIMING, new TimerEventHandler(arg_0 -> ((Logger)logger).debug(arg_0))));
    }

    @Nullable
    static War getWarTask(Project project) {
        WarPluginConvention warPluginConvention = (WarPluginConvention)project.getConvention().findPlugin(WarPluginConvention.class);
        if (warPluginConvention == null) {
            return null;
        }
        return (War)warPluginConvention.getProject().getTasks().findByName("war");
    }

    @VisibleForTesting
    GradleProjectProperties(Project project, EventEmitter eventEmitter, GradleJibLogger gradleJibLogger, JavaLayerConfigurations javaLayerConfigurations) {
        this.project = project;
        this.eventEmitter = eventEmitter;
        this.gradleJibLogger = gradleJibLogger;
        this.javaLayerConfigurations = javaLayerConfigurations;
    }

    @Override
    public JavaLayerConfigurations getJavaLayerConfigurations() {
        return this.javaLayerConfigurations;
    }

    @Override
    public EventEmitter getEventEmitter() {
        return this.eventEmitter;
    }

    @Override
    public JibLogger getLogger() {
        return this.gradleJibLogger;
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    @Nullable
    public String getMainClassFromJar() {
        ArrayList jarTasks = new ArrayList(this.project.getTasksByName("jar", false));
        if (jarTasks.size() != 1) {
            return null;
        }
        return (String)((Jar)jarTasks.get(0)).getManifest().getAttributes().get((Object)"Main-Class");
    }

    @Override
    public Path getCacheDirectory() {
        return this.project.getBuildDir().toPath().resolve("jib-cache");
    }

    @Override
    public String getJarPluginName() {
        return JAR_PLUGIN_NAME;
    }

    @Override
    public boolean isWarProject() {
        return false;
    }

    String getMainClass(JibExtension jibExtension) {
        try {
            return MainClassResolver.resolveMainClass(jibExtension.getMainClass(), this);
        }
        catch (MainClassInferenceException ex) {
            throw new GradleException(ex.getMessage(), (Throwable)ex);
        }
    }

    static FileCollection getInputFiles(File extraDirectory, Project project) {
        Task classesTask = project.getTasks().getByPath("classes");
        Set classesDependencies = classesTask.getTaskDependencies().getDependencies(classesTask);
        ArrayList<FileCollection> dependencyFileCollections = new ArrayList<FileCollection>();
        for (Task task : classesDependencies) {
            dependencyFileCollections.add(task.getOutputs().getFiles());
        }
        if (Files.exists(extraDirectory.toPath(), new LinkOption[0])) {
            return project.files(new Object[]{dependencyFileCollections, extraDirectory});
        }
        return project.files(new Object[]{dependencyFileCollections});
    }
}

