/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.frontend.JavaEntrypointConstructor;
import com.google.cloud.tools.jib.frontend.JavaLayerConfigurations;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;

class GradleLayerConfigurations {
    private static final String MAIN_SOURCE_SET_NAME = "main";

    static JavaLayerConfigurations getForProject(Project project, Logger logger, Path extraDirectory, AbsoluteUnixPath appRoot) throws IOException {
        Path resourcesOutputDirectory;
        Throwable throwable;
        Stream<Path> classFileStream;
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        SourceSet mainSourceSet = (SourceSet)javaPluginConvention.getSourceSets().getByName(MAIN_SOURCE_SET_NAME);
        ArrayList<Path> dependenciesFiles = new ArrayList<Path>();
        ArrayList<Path> snapshotDependenciesFiles = new ArrayList<Path>();
        ArrayList<Path> resourcesFiles = new ArrayList<Path>();
        ArrayList<Path> classesFiles = new ArrayList<Path>();
        ArrayList<Path> extraFiles = new ArrayList();
        FileCollection classesOutputDirectories = mainSourceSet.getOutput().getClassesDirs();
        logger.info("Adding corresponding output directories of source sets to image");
        for (File classesOutputDirectory : classesOutputDirectories) {
            if (Files.notExists(classesOutputDirectory.toPath(), new LinkOption[0])) {
                logger.info("\t'" + classesOutputDirectory + "' (not found, skipped)");
                continue;
            }
            logger.info("\t'" + classesOutputDirectory + "'");
            classFileStream = Files.list(classesOutputDirectory.toPath());
            throwable = null;
            try {
                classFileStream.forEach(classesFiles::add);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (classFileStream == null) continue;
                GradleLayerConfigurations.$closeResource(throwable, classFileStream);
            }
        }
        if (classesFiles.isEmpty()) {
            logger.warn("No classes files were found - did you compile your project?");
        }
        if (Files.exists(resourcesOutputDirectory = mainSourceSet.getOutput().getResourcesDir().toPath(), new LinkOption[0])) {
            classFileStream = null;
            try (Stream<Path> resourceFileStream = Files.list(resourcesOutputDirectory);){
                resourceFileStream.forEach(resourcesFiles::add);
            }
            catch (Throwable throwable3) {
                classFileStream = throwable3;
                throw throwable3;
            }
        }
        FileCollection allFiles = mainSourceSet.getRuntimeClasspath();
        allFiles = allFiles.minus(classesOutputDirectories);
        for (File dependencyFile : allFiles) {
            if (resourcesOutputDirectory.equals(dependencyFile.toPath())) continue;
            if (dependencyFile.getName().contains("SNAPSHOT")) {
                snapshotDependenciesFiles.add(dependencyFile.toPath());
                continue;
            }
            dependenciesFiles.add(dependencyFile.toPath());
        }
        if (Files.exists(extraDirectory, new LinkOption[0])) {
            throwable = null;
            try (Stream<Path> extraFilesLayerDirectoryFiles = Files.list(extraDirectory);){
                extraFiles = extraFilesLayerDirectoryFiles.collect(Collectors.toList());
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
        Collections.sort(dependenciesFiles);
        Collections.sort(snapshotDependenciesFiles);
        Collections.sort(resourcesFiles);
        Collections.sort(classesFiles);
        Collections.sort(extraFiles);
        return JavaLayerConfigurations.builder().setDependencyFiles(dependenciesFiles, appRoot.resolve(JavaEntrypointConstructor.DEFAULT_RELATIVE_DEPENDENCIES_PATH_ON_IMAGE)).setSnapshotDependencyFiles(snapshotDependenciesFiles, appRoot.resolve(JavaEntrypointConstructor.DEFAULT_RELATIVE_DEPENDENCIES_PATH_ON_IMAGE)).setResourceFiles(resourcesFiles, appRoot.resolve(JavaEntrypointConstructor.DEFAULT_RELATIVE_RESOURCES_PATH_ON_IMAGE)).setClassFiles(classesFiles, appRoot.resolve(JavaEntrypointConstructor.DEFAULT_RELATIVE_CLASSES_PATH_ON_IMAGE)).setExtraFiles(extraFiles, AbsoluteUnixPath.get("/")).build();
    }

    private GradleLayerConfigurations() {
    }
}

