/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.frontend.ExposedPortsParser;
import com.google.cloud.tools.jib.frontend.JavaDockerContextGenerator;
import com.google.cloud.tools.jib.frontend.JavaEntrypointConstructor;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.gradle.GradleJibLogger;
import com.google.cloud.tools.jib.gradle.GradleProjectProperties;
import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.cloud.tools.jib.gradle.JibTask;
import com.google.cloud.tools.jib.gradle.PluginConfigurationProcessor;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.common.base.Preconditions;
import com.google.common.io.InsecureRecursiveDeleteException;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class DockerContextTask
extends DefaultTask
implements JibTask {
    @Nullable
    private String targetDir;
    @Nullable
    private JibExtension jibExtension;

    @Nested
    @Nullable
    public JibExtension getJib() {
        return this.jibExtension;
    }

    @InputFiles
    public FileCollection getInputFiles() {
        return GradleProjectProperties.getInputFiles(((JibExtension)Preconditions.checkNotNull((Object)this.jibExtension)).getExtraDirectoryPath().toFile(), this.getProject());
    }

    @OutputDirectory
    public String getOutputDirectory() {
        return this.getTargetDir();
    }

    @Input
    public String getTargetDir() {
        if (this.targetDir == null) {
            return this.getProject().getBuildDir().toPath().resolve("jib-docker-context").toString();
        }
        return this.targetDir;
    }

    @Option(option="jibTargetDir", description="Directory to output the Docker context to")
    public void setTargetDir(String targetDir) {
        this.targetDir = targetDir;
    }

    @TaskAction
    public void generateDockerContext() {
        Preconditions.checkNotNull((Object)this.jibExtension);
        GradleJibLogger gradleJibLogger = new GradleJibLogger(this.getLogger());
        this.jibExtension.handleDeprecatedParameters(gradleJibLogger);
        JibSystemProperties.checkHttpTimeoutProperty();
        AbsoluteUnixPath appRoot = PluginConfigurationProcessor.getAppRootChecked(this.jibExtension);
        GradleProjectProperties gradleProjectProperties = GradleProjectProperties.getForProject(this.getProject(), this.getLogger(), this.jibExtension.getExtraDirectoryPath(), appRoot);
        String targetDir = this.getTargetDir();
        List<String> entrypoint = this.jibExtension.getContainer().getEntrypoint();
        if (entrypoint.isEmpty()) {
            String mainClass = gradleProjectProperties.getMainClass(this.jibExtension);
            entrypoint = JavaEntrypointConstructor.makeDefaultEntrypoint(appRoot, this.jibExtension.getJvmFlags(), mainClass);
        } else if (this.jibExtension.getMainClass() != null || !this.jibExtension.getJvmFlags().isEmpty()) {
            gradleJibLogger.warn("mainClass and jvmFlags are ignored when entrypoint is specified");
        }
        try {
            ExposedPortsParser.parse(this.jibExtension.getExposedPorts());
            new JavaDockerContextGenerator(gradleProjectProperties.getJavaLayerConfigurations()).setBaseImage(this.jibExtension.getBaseImage()).setEntrypoint(entrypoint).setJavaArguments(this.jibExtension.getArgs()).setExposedPorts(this.jibExtension.getExposedPorts()).setLabels(this.jibExtension.getLabels()).generate(Paths.get(targetDir, new String[0]));
            gradleJibLogger.lifecycle("Created Docker context at " + targetDir);
        }
        catch (InsecureRecursiveDeleteException ex) {
            throw new GradleException(HelpfulSuggestions.forDockerContextInsecureRecursiveDelete("Export Docker context failed because cannot clear directory '" + this.getTargetDir() + "' safely", this.getTargetDir()), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new GradleException(HelpfulSuggestions.suggest("Export Docker context failed", "check if the command-line option `--jibTargetDir` is set correctly"), (Throwable)ex);
        }
    }

    @Override
    public DockerContextTask setJibExtension(JibExtension jibExtension) {
        this.jibExtension = jibExtension;
        return this;
    }
}

