/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.cache.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.ImageConfiguration;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.gradle.GradleHelpfulSuggestionsBuilder;
import com.google.cloud.tools.jib.gradle.GradleJibLogger;
import com.google.cloud.tools.jib.gradle.GradleProjectProperties;
import com.google.cloud.tools.jib.gradle.JibExtension;
import com.google.cloud.tools.jib.gradle.JibTask;
import com.google.cloud.tools.jib.gradle.PluginConfigurationProcessor;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.cloud.tools.jib.plugins.common.BuildStepsExecutionException;
import com.google.cloud.tools.jib.plugins.common.BuildStepsRunner;
import com.google.cloud.tools.jib.plugins.common.ConfigurationPropertyValidator;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.common.base.Preconditions;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class BuildTarTask
extends DefaultTask
implements JibTask {
    private static final String HELPFUL_SUGGESTIONS_PREFIX = "Building image tarball failed";
    @Nullable
    private JibExtension jibExtension;

    @Nested
    @Nullable
    public JibExtension getJib() {
        return this.jibExtension;
    }

    @Option(option="image", description="The image reference for the target image")
    public void setTargetImage(String targetImage) {
        ((JibExtension)Preconditions.checkNotNull((Object)this.jibExtension)).getTo().setImage(targetImage);
    }

    @InputFiles
    public FileCollection getInputFiles() {
        return GradleProjectProperties.getInputFiles(((JibExtension)Preconditions.checkNotNull((Object)this.jibExtension)).getExtraDirectoryPath().toFile(), this.getProject());
    }

    @OutputFile
    public String getOutputFile() {
        return this.getTargetPath();
    }

    private String getTargetPath() {
        return this.getProject().getBuildDir().toPath().resolve("jib-image.tar").toString();
    }

    @TaskAction
    public void buildTar() throws InvalidImageReferenceException {
        Preconditions.checkNotNull((Object)this.jibExtension);
        GradleJibLogger gradleJibLogger = new GradleJibLogger(this.getLogger());
        AbsoluteUnixPath appRoot = PluginConfigurationProcessor.getAppRootChecked(this.jibExtension);
        GradleProjectProperties gradleProjectProperties = GradleProjectProperties.getForProject(this.getProject(), this.getLogger(), this.jibExtension.getExtraDirectoryPath(), appRoot);
        GradleHelpfulSuggestionsBuilder gradleHelpfulSuggestionsBuilder = new GradleHelpfulSuggestionsBuilder(HELPFUL_SUGGESTIONS_PREFIX, this.jibExtension);
        ImageReference targetImage = ConfigurationPropertyValidator.getGeneratedTargetDockerTag(this.jibExtension.getTargetImage(), gradleJibLogger, this.getProject().getName(), this.getProject().getVersion().toString(), gradleHelpfulSuggestionsBuilder.build());
        PluginConfigurationProcessor pluginConfigurationProcessor = PluginConfigurationProcessor.processCommonConfiguration(gradleJibLogger, this.jibExtension, gradleProjectProperties);
        BuildConfiguration buildConfiguration = pluginConfigurationProcessor.getBuildConfigurationBuilder().setBaseImageConfiguration(pluginConfigurationProcessor.getBaseImageConfigurationBuilder().build()).setTargetImageConfiguration(ImageConfiguration.builder(targetImage).build()).setContainerConfiguration(pluginConfigurationProcessor.getContainerConfigurationBuilder().build()).build();
        HelpfulSuggestions helpfulSuggestions = gradleHelpfulSuggestionsBuilder.setBaseImageReference(buildConfiguration.getBaseImageConfiguration().getImage()).setBaseImageHasConfiguredCredentials(pluginConfigurationProcessor.isBaseImageCredentialPresent()).setTargetImageReference(buildConfiguration.getTargetImageConfiguration().getImage()).build();
        try {
            BuildStepsRunner.forBuildTar(Paths.get(this.getTargetPath(), new String[0]), buildConfiguration).build(helpfulSuggestions);
        }
        catch (CacheDirectoryCreationException | BuildStepsExecutionException ex) {
            throw new GradleException(ex.getMessage(), ex.getCause());
        }
    }

    @Override
    public BuildTarTask setJibExtension(JibExtension jibExtension) {
        this.jibExtension = jibExtension;
        return this;
    }
}

