/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.gradle.BaseImageParameters;
import com.google.cloud.tools.jib.gradle.ContainerParameters;
import com.google.cloud.tools.jib.gradle.ExtraDirectoryParameters;
import com.google.cloud.tools.jib.gradle.TargetImageParameters;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;

public class JibExtension {
    private static final boolean DEFAULT_USE_ONLY_PROJECT_CACHE = false;
    private static final boolean DEFAULT_ALLOW_INSECURE_REGISTIRIES = false;
    private final BaseImageParameters from;
    private final TargetImageParameters to;
    private final ContainerParameters container;
    private final ExtraDirectoryParameters extraDirectory;
    private final Property<Boolean> useOnlyProjectCache;
    private final Property<Boolean> allowInsecureRegistries;

    public JibExtension(Project project) {
        ObjectFactory objectFactory = project.getObjects();
        this.from = (BaseImageParameters)objectFactory.newInstance(BaseImageParameters.class, new Object[]{"jib.from"});
        this.to = (TargetImageParameters)objectFactory.newInstance(TargetImageParameters.class, new Object[]{"jib.to"});
        this.container = (ContainerParameters)objectFactory.newInstance(ContainerParameters.class, new Object[0]);
        this.extraDirectory = (ExtraDirectoryParameters)objectFactory.newInstance(ExtraDirectoryParameters.class, new Object[]{project.getProjectDir().toPath()});
        this.useOnlyProjectCache = objectFactory.property(Boolean.class);
        this.allowInsecureRegistries = objectFactory.property(Boolean.class);
        this.useOnlyProjectCache.set((Object)false);
        this.allowInsecureRegistries.set((Object)false);
    }

    public void from(Action<? super BaseImageParameters> action) {
        action.execute((Object)this.from);
    }

    public void to(Action<? super TargetImageParameters> action) {
        action.execute((Object)this.to);
    }

    public void container(Action<? super ContainerParameters> action) {
        action.execute((Object)this.container);
    }

    public void extraDirectory(Action<? super ExtraDirectoryParameters> action) {
        action.execute((Object)this.extraDirectory);
    }

    public void setExtraDirectory(File extraDirectory) {
        this.extraDirectory.setPath(extraDirectory);
    }

    public void setAllowInsecureRegistries(boolean allowInsecureRegistries) {
        this.allowInsecureRegistries.set((Object)allowInsecureRegistries);
    }

    void setUseOnlyProjectCache(boolean useOnlyProjectCache) {
        this.useOnlyProjectCache.set((Object)useOnlyProjectCache);
    }

    @Nested
    @Optional
    public BaseImageParameters getFrom() {
        return this.from;
    }

    @Nested
    @Optional
    public TargetImageParameters getTo() {
        return this.to;
    }

    @Nested
    @Optional
    public ContainerParameters getContainer() {
        return this.container;
    }

    @Nested
    @Optional
    public ExtraDirectoryParameters getExtraDirectory() {
        return this.extraDirectory;
    }

    @Input
    @Optional
    boolean getUseOnlyProjectCache() {
        if (System.getProperty("jib.useOnlyProjectCache") != null) {
            return Boolean.getBoolean("jib.useOnlyProjectCache");
        }
        return (Boolean)this.useOnlyProjectCache.get();
    }

    @Input
    @Optional
    boolean getAllowInsecureRegistries() {
        if (System.getProperty("jib.allowInsecureRegistries") != null) {
            return Boolean.getBoolean("jib.allowInsecureRegistries");
        }
        return (Boolean)this.allowInsecureRegistries.get();
    }
}

