/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.configuration.FilePermissions;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.frontend.JavaEntrypointConstructor;
import com.google.cloud.tools.jib.frontend.JavaLayerConfigurations;
import com.google.cloud.tools.jib.gradle.GradleProjectProperties;
import com.google.cloud.tools.jib.plugins.common.JavaLayerConfigurationsHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;

class GradleLayerConfigurations {
    private static final String MAIN_SOURCE_SET_NAME = "main";

    static JavaLayerConfigurations getForProject(Project project, Logger logger, Path extraDirectory, Map<AbsoluteUnixPath, FilePermissions> extraDirectoryPermissions, AbsoluteUnixPath appRoot) throws IOException {
        if (GradleProjectProperties.getWarTask(project) != null) {
            logger.info("WAR project identified, creating WAR image: " + project.getDisplayName());
            return GradleLayerConfigurations.getForWarProject(project, extraDirectory, extraDirectoryPermissions, appRoot);
        }
        return GradleLayerConfigurations.getForNonWarProject(project, logger, extraDirectory, extraDirectoryPermissions, appRoot);
    }

    private static JavaLayerConfigurations getForNonWarProject(Project project, Logger logger, Path extraDirectory, Map<AbsoluteUnixPath, FilePermissions> extraDirectoryPermissions, AbsoluteUnixPath appRoot) throws IOException {
        AbsoluteUnixPath dependenciesExtractionPath = appRoot.resolve(JavaEntrypointConstructor.DEFAULT_RELATIVE_DEPENDENCIES_PATH_ON_IMAGE);
        AbsoluteUnixPath resourcesExtractionPath = appRoot.resolve(JavaEntrypointConstructor.DEFAULT_RELATIVE_RESOURCES_PATH_ON_IMAGE);
        AbsoluteUnixPath classesExtractionPath = appRoot.resolve(JavaEntrypointConstructor.DEFAULT_RELATIVE_CLASSES_PATH_ON_IMAGE);
        JavaLayerConfigurations.Builder layerBuilder = JavaLayerConfigurations.builder();
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        SourceSet mainSourceSet = (SourceSet)javaPluginConvention.getSourceSets().getByName(MAIN_SOURCE_SET_NAME);
        FileCollection classesOutputDirectories = mainSourceSet.getOutput().getClassesDirs();
        Path resourcesOutputDirectory = mainSourceSet.getOutput().getResourcesDir().toPath();
        FileCollection allFiles = mainSourceSet.getRuntimeClasspath();
        FileCollection dependencyFiles = allFiles.minus(classesOutputDirectories).filter(file -> !file.toPath().equals(resourcesOutputDirectory));
        logger.info("Adding corresponding output directories of source sets to image");
        for (File classesOutputDirectory : classesOutputDirectories) {
            if (Files.notExists(classesOutputDirectory.toPath(), new LinkOption[0])) {
                logger.info("\t'" + classesOutputDirectory + "' (not found, skipped)");
                continue;
            }
            logger.info("\t'" + classesOutputDirectory + "'");
            layerBuilder.addDirectoryContents(JavaLayerConfigurations.LayerType.CLASSES, classesOutputDirectory.toPath(), path -> true, classesExtractionPath);
        }
        if (classesOutputDirectories.filter(File::exists).isEmpty()) {
            logger.warn("No classes files were found - did you compile your project?");
        }
        if (Files.exists(resourcesOutputDirectory, new LinkOption[0])) {
            layerBuilder.addDirectoryContents(JavaLayerConfigurations.LayerType.RESOURCES, resourcesOutputDirectory, path -> true, resourcesExtractionPath);
        }
        for (File dependencyFile : dependencyFiles) {
            boolean isSnapshot = dependencyFile.getName().contains("SNAPSHOT");
            JavaLayerConfigurations.LayerType layerType = isSnapshot ? JavaLayerConfigurations.LayerType.SNAPSHOT_DEPENDENCIES : JavaLayerConfigurations.LayerType.DEPENDENCIES;
            layerBuilder.addFile(layerType, dependencyFile.toPath(), dependenciesExtractionPath.resolve(dependencyFile.getName()));
        }
        if (Files.exists(extraDirectory, new LinkOption[0])) {
            layerBuilder.addDirectoryContents(JavaLayerConfigurations.LayerType.EXTRA_FILES, extraDirectory, path -> true, AbsoluteUnixPath.get("/"), extraDirectoryPermissions);
        }
        return layerBuilder.build();
    }

    private static JavaLayerConfigurations getForWarProject(Project project, Path extraDirectory, Map<AbsoluteUnixPath, FilePermissions> extraDirectoryPermissions, AbsoluteUnixPath appRoot) throws IOException {
        Path explodedWarPath = GradleProjectProperties.getExplodedWarDirectory(project);
        return JavaLayerConfigurationsHelper.fromExplodedWar(explodedWarPath, appRoot, extraDirectory, extraDirectoryPermissions);
    }

    private GradleLayerConfigurations() {
    }
}

