/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.gradle;

import com.google.cloud.tools.jib.plugins.common.ConfigurationPropertyValidator;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;

public class ExtraDirectoryParameters {
    private Path path;
    private Map<String, String> permissions = Collections.emptyMap();

    private static Path resolveDefaultExtraDirectory(Path projectDirectory) {
        return projectDirectory.resolve("src").resolve("main").resolve("jib");
    }

    @Inject
    public ExtraDirectoryParameters(Path projectDirectory) {
        this.path = ExtraDirectoryParameters.resolveDefaultExtraDirectory(projectDirectory);
    }

    @Input
    public String getPathString() {
        if (System.getProperty("jib.extraDirectory.path") != null) {
            return System.getProperty("jib.extraDirectory.path");
        }
        return this.path.toString();
    }

    @Internal
    public Path getPath() {
        if (System.getProperty("jib.extraDirectory.path") != null) {
            return Paths.get(System.getProperty("jib.extraDirectory.path"), new String[0]);
        }
        return this.path;
    }

    public void setPath(File path) {
        this.path = path.toPath();
    }

    @Input
    public Map<String, String> getPermissions() {
        if (System.getProperty("jib.extraDirectory.permissions") != null) {
            return ConfigurationPropertyValidator.parseMapProperty(System.getProperty("jib.extraDirectory.permissions"));
        }
        return this.permissions;
    }

    public void setPermissions(Map<String, String> permissions) {
        this.permissions = permissions;
    }
}

