/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.RetrieveRegistryCredentialsStep;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.credentials.Credential;
import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.Authorizations;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerCountMismatchException;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.image.json.BadContainerConfigurationFormatException;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.JsonToImageTranslator;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.image.json.UnknownManifestFormatException;
import com.google.cloud.tools.jib.image.json.V21ManifestTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.registry.RegistryAuthenticator;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.cloud.tools.jib.registry.RegistryUnauthorizedException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

class PullBaseImageStep
implements AsyncStep<BaseImageWithAuthorization>,
Callable<BaseImageWithAuthorization> {
    private static final String DESCRIPTION = "Pulling base image manifest";
    private final BuildConfiguration buildConfiguration;
    private final ListenableFuture<BaseImageWithAuthorization> listenableFuture;

    PullBaseImageStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration) {
        this.buildConfiguration = buildConfiguration;
        this.listenableFuture = listeningExecutorService.submit((Callable)this);
    }

    @Override
    public ListenableFuture<BaseImageWithAuthorization> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public BaseImageWithAuthorization call() throws IOException, RegistryException, LayerPropertyNotFoundException, LayerCountMismatchException, ExecutionException, BadContainerConfigurationFormatException, RegistryAuthenticationFailedException {
        this.buildConfiguration.getEventDispatcher().dispatch(LogEvent.lifecycle("Getting base image " + this.buildConfiguration.getBaseImageConfiguration().getImage() + "..."));
        Throwable throwable = null;
        try (TimerEventDispatcher ignored = new TimerEventDispatcher(this.buildConfiguration.getEventDispatcher(), DESCRIPTION);){
            BaseImageWithAuthorization baseImageWithAuthorization = new BaseImageWithAuthorization(this.pullBaseImage(null), null);
            return baseImageWithAuthorization;
        }
        catch (RegistryUnauthorizedException ex) {
            this.buildConfiguration.getEventDispatcher().dispatch(LogEvent.lifecycle("The base image requires auth. Trying again for " + this.buildConfiguration.getBaseImageConfiguration().getImage() + "..."));
            ListeningExecutorService directExecutorService = MoreExecutors.newDirectExecutorService();
            RetrieveRegistryCredentialsStep retrieveBaseRegistryCredentialsStep = RetrieveRegistryCredentialsStep.forBaseImage(directExecutorService, this.buildConfiguration);
            Credential registryCredential = NonBlockingSteps.get(retrieveBaseRegistryCredentialsStep);
            Authorization registryAuthorization = registryCredential == null ? null : Authorizations.withBasicCredentials(registryCredential.getUsername(), registryCredential.getPassword());
            try {
                BaseImageWithAuthorization baseImageWithAuthorization = new BaseImageWithAuthorization(this.pullBaseImage(registryAuthorization), registryAuthorization);
                return baseImageWithAuthorization;
            }
            catch (RegistryUnauthorizedException registryUnauthorizedException) {
                RegistryAuthenticator registryAuthenticator = RegistryAuthenticator.initializer(this.buildConfiguration.getEventDispatcher(), this.buildConfiguration.getBaseImageConfiguration().getImageRegistry(), this.buildConfiguration.getBaseImageConfiguration().getImageRepository()).setAllowInsecureRegistries(this.buildConfiguration.getAllowInsecureRegistries()).initialize();
                if (registryAuthenticator == null) {
                    this.buildConfiguration.getEventDispatcher().dispatch(LogEvent.error("Failed to retrieve authentication challenge for registry that required token authentication"));
                    throw registryUnauthorizedException;
                }
                registryAuthorization = registryAuthenticator.setAuthorization(registryAuthorization).authenticatePull();
                BaseImageWithAuthorization baseImageWithAuthorization = new BaseImageWithAuthorization(this.pullBaseImage(registryAuthorization), registryAuthorization);
                return baseImageWithAuthorization;
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private Image<Layer> pullBaseImage(@Nullable Authorization registryAuthorization) throws IOException, RegistryException, LayerPropertyNotFoundException, LayerCountMismatchException, BadContainerConfigurationFormatException {
        RegistryClient registryClient = this.buildConfiguration.newBaseImageRegistryClientFactory().setAuthorization(registryAuthorization).newRegistryClient();
        ManifestTemplate manifestTemplate = registryClient.pullManifest(this.buildConfiguration.getBaseImageConfiguration().getImageTag());
        switch (manifestTemplate.getSchemaVersion()) {
            case 1: {
                V21ManifestTemplate v21ManifestTemplate = (V21ManifestTemplate)manifestTemplate;
                return JsonToImageTranslator.toImage(v21ManifestTemplate);
            }
            case 2: {
                V22ManifestTemplate v22ManifestTemplate = (V22ManifestTemplate)manifestTemplate;
                if (v22ManifestTemplate.getContainerConfiguration() == null || v22ManifestTemplate.getContainerConfiguration().getDigest() == null) {
                    throw new UnknownManifestFormatException("Invalid container configuration in Docker V2.2 manifest: \n" + Blobs.writeToString(JsonTemplateMapper.toBlob(v22ManifestTemplate)));
                }
                String containerConfigurationString = Blobs.writeToString(registryClient.pullBlob(v22ManifestTemplate.getContainerConfiguration().getDigest()));
                ContainerConfigurationTemplate containerConfigurationTemplate = JsonTemplateMapper.readJson(containerConfigurationString, ContainerConfigurationTemplate.class);
                return JsonToImageTranslator.toImage(v22ManifestTemplate, containerConfigurationTemplate);
            }
        }
        throw new IllegalStateException("Unknown manifest schema version");
    }

    static class BaseImageWithAuthorization {
        private final Image<Layer> baseImage;
        @Nullable
        private final Authorization baseImageAuthorization;

        @VisibleForTesting
        BaseImageWithAuthorization(Image<Layer> baseImage, @Nullable Authorization baseImageAuthorization) {
            this.baseImage = baseImage;
            this.baseImageAuthorization = baseImageAuthorization;
        }

        Image<Layer> getBaseImage() {
            return this.baseImage;
        }

        @Nullable
        Authorization getBaseImageAuthorization() {
            return this.baseImageAuthorization;
        }
    }
}

