/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.postman.newman;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.util.Map;
import org.gradle.api.Project;
import uk.co.mruoc.postman.settings.NewmanSettings;
import uk.co.mruoc.postman.task.util.Json;

class NewmanConfig {
    private final Project project;
    private final NewmanSettings settings;

    NewmanConfig(Project project, NewmanSettings settings) {
        this.project = project;
        this.settings = settings;
    }

    String toJsonFor(File collection) {
        return new JsonBuilder(collection).build();
    }

    private class JsonBuilder {
        private final JsonObject params = Json.object();
        private final File collection;

        JsonBuilder(File collection) {
            this.collection = collection;
        }

        private String build() {
            this.buildParameters();
            return this.params.toString();
        }

        private void buildParameters() {
            this.addCollection();
            this.addEnvironment();
            this.addGlobals();
            this.addReporters();
            this.addBail();
            this.addNoColor();
            this.addDisableUnicode();
            this.addSecure();
            this.addIgnoreRedirects();
            this.addEnvVars();
            this.addGlobalVars();
        }

        private void addCollection() {
            this.params.add("collection", (JsonElement)Json.primitive(this.collection.toString()));
        }

        private void addReporters() {
            JsonArray reporters = Json.array();
            JsonObject reporter = Json.object();
            this.addCli(reporters);
            this.addJunit(reporters, reporter);
            this.addJson(reporters, reporter);
            this.addHtml(reporters, reporter);
            if (!Json.empty(reporters)) {
                this.params.add("reporters", (JsonElement)reporters);
            }
            if (!Json.empty(reporter)) {
                this.params.add("reporter", (JsonElement)reporter);
            }
        }

        private void addJunit(JsonArray reporters, JsonObject reporter) {
            if (NewmanConfig.this.settings.getXmlReportDir() != null) {
                reporters.add((JsonElement)Json.primitive("junit"));
                reporter.add("junit", (JsonElement)Json.object("export", this.projectFile(NewmanConfig.this.settings.getXmlReportDir(), "TEST-postman-" + this.collection.getName() + ".xml")));
            }
        }

        private void addJson(JsonArray reporters, JsonObject reporter) {
            if (NewmanConfig.this.settings.getJsonReportDir() != null) {
                reporters.add("json");
                reporter.add("json", (JsonElement)Json.object("export", this.projectFile(NewmanConfig.this.settings.getJsonReportDir(), this.endsWithJson("TEST-postman-" + this.collection.getName()))));
            }
        }

        private void addHtml(JsonArray reporters, JsonObject reporter) {
            if (NewmanConfig.this.settings.getHtmlReportDir() != null) {
                reporters.add("html");
                JsonObject htmlOptions = Json.object();
                reporter.add("html", (JsonElement)htmlOptions);
                htmlOptions.addProperty("export", this.projectFile(NewmanConfig.this.settings.getHtmlReportDir(), "TEST-postman-" + this.collection.getName() + ".html"));
                if (NewmanConfig.this.settings.getHtmlTemplate() != null) {
                    htmlOptions.addProperty("template", this.projectFile(NewmanConfig.this.settings.getHtmlTemplate()));
                }
            }
        }

        private String projectFile(String ... parts) {
            return this.compose(NewmanConfig.this.project.getProjectDir(), parts).toString();
        }

        private File compose(File file, String[] parts) {
            for (String part : parts) {
                file = new File(file, part);
            }
            return file;
        }

        private void addCli(JsonArray reporters) {
            if (NewmanConfig.this.settings.getCliReport()) {
                reporters.add((JsonElement)Json.primitive("cli"));
            }
        }

        private void addEnvironment() {
            if (NewmanConfig.this.settings.getEnvironment() != null) {
                this.params.add("environment", (JsonElement)new JsonPrimitive(NewmanConfig.this.settings.getEnvironment().toString()));
            }
        }

        private void addGlobals() {
            if (NewmanConfig.this.settings.getGlobals() != null) {
                this.params.add("globals", (JsonElement)new JsonPrimitive(NewmanConfig.this.settings.getGlobals().toString()));
            }
        }

        private void addEnvVars() {
            this.addVars("envVar", NewmanConfig.this.settings.getEnvVars());
        }

        private void addGlobalVars() {
            this.addVars("globalVar", NewmanConfig.this.settings.getGlobalVars());
        }

        private void addVars(String name, Map<String, String> values) {
            if (values == null || values.isEmpty()) {
                return;
            }
            this.params.add(name, (JsonElement)this.toVars(values));
        }

        private JsonArray toVars(Map<String, String> values) {
            JsonArray vars = Json.array();
            values.entrySet().stream().map(e -> this.toVar((String)e.getKey(), (String)e.getValue())).forEach(arg_0 -> ((JsonArray)vars).add(arg_0));
            return vars;
        }

        private JsonObject toVar(String key, String value) {
            JsonObject var = Json.object();
            var.addProperty("key", key);
            var.addProperty("value", value);
            return var;
        }

        private void addBail() {
            this.params.add("bail", (JsonElement)Json.primitive(NewmanConfig.this.settings.getStopOnError()));
        }

        private void addNoColor() {
            this.params.add("noColor", (JsonElement)Json.primitive(NewmanConfig.this.settings.getNoColor()));
        }

        private void addDisableUnicode() {
            this.params.add("disableUnicode", (JsonElement)Json.primitive(NewmanConfig.this.settings.getDisableUnicode()));
        }

        private void addSecure() {
            this.params.add("insecure", (JsonElement)Json.primitive(!NewmanConfig.this.settings.getSecure()));
        }

        private void addIgnoreRedirects() {
            this.params.add("ignoreRedirects", (JsonElement)Json.primitive(NewmanConfig.this.settings.getIgnoreRedirects()));
        }

        private String endsWithJson(String fileName) {
            if (fileName.endsWith(".json")) {
                return fileName;
            }
            return fileName + ".json";
        }
    }
}

