/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import shadow.org.apache.tools.ant.BuildException;
import shadow.org.apache.tools.ant.Task;
import shadow.org.apache.tools.ant.taskdefs.condition.Os;
import shadow.org.apache.tools.ant.types.DataType;
import shadow.org.apache.tools.ant.types.EnumeratedAttribute;
import shadow.org.apache.tools.ant.types.Mapper;
import shadow.org.apache.tools.ant.types.Path;
import shadow.org.apache.tools.ant.types.Reference;
import shadow.org.apache.tools.ant.types.Resource;
import shadow.org.apache.tools.ant.types.ResourceCollection;
import shadow.org.apache.tools.ant.types.resources.Resources;
import shadow.org.apache.tools.ant.types.resources.Union;
import shadow.org.apache.tools.ant.util.FileNameMapper;
import shadow.org.apache.tools.ant.util.IdentityMapper;

public class PathConvert
extends Task {
    private static boolean onWindows = Os.isFamily("dos");
    private Resources path = null;
    private Reference refid = null;
    private String targetOS = null;
    private boolean targetWindows = false;
    private boolean setonempty = true;
    private String property = null;
    private List<MapEntry> prefixMap = new Vector<MapEntry>();
    private String pathSep = null;
    private String dirSep = null;
    private Mapper mapper = null;
    private boolean preserveDuplicates;

    public Path createPath() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        Path result = new Path(this.getProject());
        this.add(result);
        return result;
    }

    public void add(ResourceCollection rc) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.getPath().add(rc);
    }

    private synchronized Resources getPath() {
        if (this.path == null) {
            this.path = new Resources(this.getProject());
            this.path.setCache(true);
        }
        return this.path;
    }

    public MapEntry createMap() {
        MapEntry entry = new MapEntry();
        this.prefixMap.add(entry);
        return entry;
    }

    @Deprecated
    public void setTargetos(String target) {
        TargetOs to = new TargetOs();
        to.setValue(target);
        this.setTargetos(to);
    }

    public void setTargetos(TargetOs target) {
        this.targetOS = target.getValue();
        this.targetWindows = !"unix".equals(this.targetOS) && !"tandem".equals(this.targetOS);
    }

    public void setSetonempty(boolean setonempty) {
        this.setonempty = setonempty;
    }

    public void setProperty(String p) {
        this.property = p;
    }

    public void setRefid(Reference r) {
        if (this.path != null) {
            throw this.noChildrenAllowed();
        }
        this.refid = r;
    }

    public void setPathSep(String sep) {
        this.pathSep = sep;
    }

    public void setDirSep(String sep) {
        this.dirSep = sep;
    }

    public void setPreserveDuplicates(boolean preserveDuplicates) {
        this.preserveDuplicates = preserveDuplicates;
    }

    public boolean isPreserveDuplicates() {
        return this.preserveDuplicates;
    }

    public boolean isReference() {
        return this.refid != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        Resources savedPath = this.path;
        String savedPathSep = this.pathSep;
        String savedDirSep = this.dirSep;
        try {
            if (this.isReference()) {
                Object o = this.refid.getReferencedObject(this.getProject());
                if (!(o instanceof ResourceCollection)) {
                    throw new BuildException("refid '%s' does not refer to a resource collection.", this.refid.getRefId());
                }
                this.getPath().add((ResourceCollection)o);
            }
            this.validateSetup();
            String fromDirSep = onWindows ? "\\" : "/";
            StringBuilder rslt = new StringBuilder();
            DataType resources = this.isPreserveDuplicates() ? this.path : new Union(this.path);
            ArrayList<String> ret = new ArrayList<String>();
            FileNameMapper mapperImpl = this.mapper == null ? new IdentityMapper() : this.mapper.getImplementation();
            Iterator iterator = resources.iterator();
            while (iterator.hasNext()) {
                Resource r = (Resource)iterator.next();
                String[] mapped = mapperImpl.mapFileName(String.valueOf(r));
                for (int m = 0; mapped != null && m < mapped.length; ++m) {
                    ret.add(mapped[m]);
                }
            }
            boolean first = true;
            for (String string : ret) {
                String elem = this.mapElement(string);
                if (!first) {
                    rslt.append(this.pathSep);
                }
                first = false;
                StringTokenizer stDirectory = new StringTokenizer(elem, fromDirSep, true);
                while (stDirectory.hasMoreTokens()) {
                    String token = stDirectory.nextToken();
                    rslt.append(fromDirSep.equals(token) ? this.dirSep : token);
                }
            }
            if (this.setonempty || rslt.length() > 0) {
                String value = rslt.toString();
                if (this.property == null) {
                    this.log(value);
                } else {
                    this.log("Set property " + this.property + " = " + value, 3);
                    this.getProject().setNewProperty(this.property, value);
                }
            }
        }
        finally {
            this.path = savedPath;
            this.dirSep = savedDirSep;
            this.pathSep = savedPathSep;
        }
    }

    private String mapElement(String elem) {
        for (MapEntry entry : this.prefixMap) {
            String newElem = entry.apply(elem);
            if (newElem == elem) continue;
            return newElem;
        }
        return elem;
    }

    public void addMapper(Mapper mapper) {
        if (this.mapper != null) {
            throw new BuildException("Cannot define more than one mapper");
        }
        this.mapper = mapper;
    }

    public void add(FileNameMapper fileNameMapper) {
        Mapper m = new Mapper(this.getProject());
        m.add(fileNameMapper);
        this.addMapper(m);
    }

    private void validateSetup() throws BuildException {
        if (this.path == null) {
            throw new BuildException("You must specify a path to convert");
        }
        String dsep = File.separator;
        String psep = File.pathSeparator;
        if (this.targetOS != null) {
            psep = this.targetWindows ? ";" : ":";
            String string = dsep = this.targetWindows ? "\\" : "/";
        }
        if (this.pathSep != null) {
            psep = this.pathSep;
        }
        if (this.dirSep != null) {
            dsep = this.dirSep;
        }
        this.pathSep = psep;
        this.dirSep = dsep;
    }

    private BuildException noChildrenAllowed() {
        return new BuildException("You must not specify nested elements when using the refid attribute.");
    }

    public class MapEntry {
        private String from = null;
        private String to = null;

        public void setFrom(String from) {
            this.from = from;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public String apply(String elem) {
            if (this.from == null || this.to == null) {
                throw new BuildException("Both 'from' and 'to' must be set in a map entry");
            }
            String cmpElem = onWindows ? elem.toLowerCase().replace('\\', '/') : elem;
            String cmpFrom = onWindows ? this.from.toLowerCase().replace('\\', '/') : this.from;
            return cmpElem.startsWith(cmpFrom) ? this.to + elem.substring(this.from.length()) : elem;
        }
    }

    public static class TargetOs
    extends EnumeratedAttribute {
        @Override
        public String[] getValues() {
            return new String[]{"windows", "unix", "netware", "os/2", "tandem"};
        }
    }
}

