/*
 * Decompiled with CFR 0.152.
 */
package com.github.honourednihilist.gradle.postgresql.embedded;

import com.github.honourednihilist.gradle.postgresql.embedded.EmbeddedPostgres;
import com.github.honourednihilist.gradle.postgresql.embedded.PostgresqlEmbeddedExtension;
import java.io.IOException;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;

public class StartPostgresTask
extends DefaultTask {
    static final String NAME = "startPostgres";
    @Internal
    private EmbeddedPostgres postgres;

    public StartPostgresTask() {
        this.setGroup("Embedded PostgreSQL server");
        this.setDescription("Runs embedded PostgreSQL server.");
    }

    @TaskAction
    public void start() throws IOException {
        this.getLogger().info("Starting postgres...");
        this.postgres.start();
        this.getLogger().info("Postgres has been started. Url = " + this.postgres.getJdbcUrl());
    }

    public void stop() {
        if (this.postgres.isStarted()) {
            this.getLogger().info("Stopping postgres...");
            this.sleepBeforeStop();
            this.postgres.stop();
            this.getLogger().info("Postgres has been stopped");
        }
    }

    private void sleepBeforeStop() {
        PostgresqlEmbeddedExtension extension = (PostgresqlEmbeddedExtension)this.getProject().getExtensions().getByType(PostgresqlEmbeddedExtension.class);
        if (extension.getTimeoutMillisBeforeStop() > 0) {
            this.getLogger().info("Sleeping {} millis before stopping postgres", (Object)extension.getTimeoutMillisBeforeStop());
            try {
                Thread.sleep(extension.getTimeoutMillisBeforeStop());
            }
            catch (InterruptedException e) {
                this.getLogger().error("", (Throwable)e);
            }
        }
    }

    public EmbeddedPostgres getPostgres() {
        return this.postgres;
    }

    public void setPostgres(EmbeddedPostgres postgres) {
        this.postgres = postgres;
    }
}

