/*
 * Decompiled with CFR 0.152.
 */
package com.github.honourednihilist.gradle.postgresql.embedded;

import com.github.honourednihilist.gradle.postgresql.embedded.EmbeddedPostgres;
import com.github.honourednihilist.gradle.postgresql.embedded.PostgresqlEmbeddedExtension;
import com.github.honourednihilist.gradle.postgresql.embedded.StartPostgresTask;
import de.flapdoodle.embed.process.distribution.IVersion;
import java.util.LinkedHashMap;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import ru.yandex.qatools.embed.postgresql.distribution.Version;

public class GradlePostgresqlEmbeddedPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getExtensions().create("postgresEmbedded", PostgresqlEmbeddedExtension.class, new Object[0]);
        StartPostgresTask startTask = (StartPostgresTask)project.getTasks().create("startPostgres", StartPostgresTask.class);
        project.afterEvaluate(pro -> {
            PostgresqlEmbeddedExtension extension = (PostgresqlEmbeddedExtension)pro.getExtensions().getByType(PostgresqlEmbeddedExtension.class);
            EmbeddedPostgres postgres = new EmbeddedPostgres(this.parseVersion(extension.getVersion()), extension.getHost(), extension.getPort(), extension.getDbName(), extension.getUsername(), extension.getPassword(), extension.getArtifactStorePath());
            startTask.setPostgres(postgres);
            if (extension.isStopWhenBuildFinished()) {
                project.getGradle().buildFinished(buildResult -> startTask.stop());
            }
        });
    }

    IVersion parseVersion(String version) {
        LinkedHashMap<String, Object> versions = new LinkedHashMap<String, Object>();
        versions.put(Version.Main.PRODUCTION.name(), Version.Main.PRODUCTION);
        versions.put(Version.Main.V10.name(), Version.Main.V10);
        versions.put(Version.Main.V9_6.name(), Version.Main.V9_6);
        versions.put(Version.Main.V9_5.name(), Version.Main.V9_5);
        versions.put(Version.V10_2.name(), Version.V10_2);
        versions.put(Version.V9_6_7.name(), Version.V9_6_7);
        versions.put(Version.V10_2.asInDownloadPath(), Version.V10_2);
        versions.put(Version.V9_6_7.asInDownloadPath(), Version.V9_6_7);
        return versions.getOrDefault(version, () -> version);
    }
}

