/*
 * Decompiled with CFR 0.152.
 */
package com.github.honourednihilist.gradle.postgresql.embedded;

import de.flapdoodle.embed.process.builder.AbstractBuilder;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.io.IStreamProcessor;
import de.flapdoodle.embed.process.io.Slf4jLevel;
import de.flapdoodle.embed.process.io.Slf4jStreamProcessor;
import de.flapdoodle.embed.process.io.directories.FixedPath;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.runtime.Network;
import de.flapdoodle.embed.process.store.ArtifactStoreBuilder;
import de.flapdoodle.embed.process.store.PostgresArtifactStoreBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import org.slf4j.LoggerFactory;
import ru.yandex.qatools.embed.postgresql.Command;
import ru.yandex.qatools.embed.postgresql.PostgresExecutable;
import ru.yandex.qatools.embed.postgresql.PostgresProcess;
import ru.yandex.qatools.embed.postgresql.PostgresStarter;
import ru.yandex.qatools.embed.postgresql.config.AbstractPostgresConfig;
import ru.yandex.qatools.embed.postgresql.config.PostgresConfig;
import ru.yandex.qatools.embed.postgresql.config.PostgresDownloadConfigBuilder;
import ru.yandex.qatools.embed.postgresql.config.RuntimeConfigBuilder;
import ru.yandex.qatools.embed.postgresql.ext.LogWatchStreamProcessor;

public class EmbeddedPostgres {
    private final IVersion version;
    private final String host;
    private final int port;
    private final String dbName;
    private final String username;
    private final String password;
    private final String artifactStorePath;
    private PostgresProcess process;
    private String jdbcUrl;

    public EmbeddedPostgres(IVersion version, String host, int port, String dbName, String username, String password, String artifactStorePath) {
        this.version = version;
        this.host = host;
        this.port = port;
        this.dbName = dbName;
        this.username = username;
        this.password = password;
        this.artifactStorePath = artifactStorePath;
    }

    public synchronized void start() throws IOException {
        if (this.process != null) {
            throw new IllegalStateException();
        }
        Command command = Command.Postgres;
        IDownloadConfig downloadConfig = new PostgresDownloadConfigBuilder().defaultsForCommand(command).artifactStorePath((IDirectory)new FixedPath(this.artifactStorePath)).build();
        ArtifactStoreBuilder artifactStoreBuilder = new PostgresArtifactStoreBuilder().defaults(command).download(downloadConfig);
        LogWatchStreamProcessor logWatch = new LogWatchStreamProcessor("started", new HashSet<String>(Collections.singletonList("failed")), (IStreamProcessor)new Slf4jStreamProcessor(LoggerFactory.getLogger((String)"postgres"), Slf4jLevel.TRACE));
        IRuntimeConfig runtimeConfig = new RuntimeConfigBuilder().defaults(command).processOutput(new ProcessOutput((IStreamProcessor)logWatch, (IStreamProcessor)logWatch, (IStreamProcessor)logWatch)).artifactStore((AbstractBuilder)artifactStoreBuilder).build();
        PostgresStarter starter = new PostgresStarter(PostgresExecutable.class, runtimeConfig);
        PostgresConfig config = new PostgresConfig(this.version, new AbstractPostgresConfig.Net(this.host, this.port == 0 ? Network.getFreeServerPort() : this.port), new AbstractPostgresConfig.Storage(this.dbName), new AbstractPostgresConfig.Timeout(), new AbstractPostgresConfig.Credentials(this.username, this.password));
        this.process = (PostgresProcess)((PostgresExecutable)starter.prepare((IExecutableProcessConfig)config)).start();
        this.jdbcUrl = "jdbc:postgresql://" + config.net().host() + ":" + config.net().port() + "/" + config.storage().dbName();
    }

    public synchronized void stop() {
        if (this.process == null) {
            throw new IllegalStateException();
        }
        this.process.stop();
        this.process = null;
    }

    public synchronized boolean isStarted() {
        return this.process != null;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }
}

