/*
 * Decompiled with CFR 0.152.
 */
package com.github.gregwhitaker.gitignore.tasks;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Paths;
import java.util.Scanner;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;

public class PrintGitIgnoreTask
extends DefaultTask {
    public PrintGitIgnoreTask() {
        this.setGroup("gitignore");
        this.setDescription("Prints the .gitignore file for the project.");
    }

    @TaskAction
    public void run() {
        block9: {
            File file = Paths.get(this.getProject().getProjectDir().getAbsolutePath(), ".gitignore").toFile();
            if (file.exists()) {
                try (Scanner scanner = new Scanner(file);){
                    while (scanner.hasNextLine()) {
                        System.out.println(scanner.nextLine());
                    }
                    break block9;
                }
                catch (FileNotFoundException e) {
                    throw new GradleException("Project does not contain a '.gitignore' file.", (Throwable)e);
                }
            }
            throw new GradleException("Project does not contain a '.gitignore' file.");
        }
    }
}

