/*
 * Decompiled with CFR 0.152.
 */
package com.github.gregwhitaker.gitignore.tasks;

import com.github.gregwhitaker.gitignore.GitIgnoreExtension;
import com.github.gregwhitaker.gitignore.facets.FacetDetectors;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.TaskAction;

public class CreateGitIgnoreTask
extends DefaultTask {
    private static final String GITIGNORE_BASE_URL = "https://www.toptal.com/developers/gitignore/api/";
    private static final List<String> DEFAULT_FACETS = Arrays.asList("gradle");

    public CreateGitIgnoreTask() {
        this.setGroup("gitignore");
        this.setDescription("Creates a .gitignore file for the project.");
    }

    @TaskAction
    public void run() {
        GitIgnoreExtension ext = (GitIgnoreExtension)this.getProject().getExtensions().findByType(GitIgnoreExtension.class);
        String contents = null;
        if (ext.getUrl() != null) {
            contents = this.getUrl(ext.getUrl());
        } else {
            HashSet<String> facets = new HashSet<String>(DEFAULT_FACETS);
            if (ext.isAutoDetect()) {
                FacetDetectors.detect(this.getProject(), facets);
            }
            if (ext.getFacets() != null) {
                facets.addAll(ext.getFacets());
            }
            contents = this.getUrl(this.gitignoreUrl(facets));
        }
        if (contents.length() > 0) {
            File file = Paths.get(this.getProject().getProjectDir().getAbsolutePath(), ".gitignore").toFile();
            try {
                FileUtils.writeStringToFile((File)file, (String)contents, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new GradleException(String.format("Error occurred while writing '.gitignore' file. [file: '%s']", file.getAbsolutePath()));
            }
        }
    }

    private String gitignoreUrl(Set<String> facets) {
        String url = GITIGNORE_BASE_URL;
        if (facets != null) {
            url = url + String.join((CharSequence)",", facets);
        }
        return url;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getUrl(String url) {
        if (!UrlValidator.getInstance().isValid(url)) {
            throw new GradleException(String.format("Invalid url. [url: '%s']", url));
        }
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().get().url(url).build();
        try (Response response = client.newCall(request).execute();){
            if (response.isSuccessful()) {
                String string = response.body().string();
                return string;
            }
            if (response.code() == 404) {
                throw new GradleException(String.format("Resource not found. [url: '%s']", url));
            }
            throw new GradleException(String.format("Error occurred while retrieving data from url. [code: '%s', url: '%s']", response.code(), url));
        }
        catch (IOException e) {
            throw new GradleException(String.format("Error occurred while retrieving data from url. [url: '%s']", url));
        }
    }
}

