/*
 * Decompiled with CFR 0.152.
 */
package com.github.gregwhitaker.gitignore;

import com.github.gregwhitaker.gitignore.GitIgnoreExtension;
import com.github.gregwhitaker.gitignore.GitIgnoreModule;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class GitIgnorePlugin
implements Plugin<Project> {
    public static final String GROUP_NAME = "gitignore";

    public void apply(Project project) {
        this.registerExtension(project);
        project.afterEvaluate(this::loadModules);
    }

    private void registerExtension(Project project) {
        project.getLogger().info("Registering 'gitignore' extension");
        project.getExtensions().add(GROUP_NAME, (Object)new GitIgnoreExtension());
    }

    private void loadModules(Project project) {
        GitIgnoreModule.load(project);
    }
}

