/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.osgi.plugins.osgi;

import com.github.blindpirate.osgi.plugins.osgi.OsgiManifest;
import com.github.blindpirate.osgi.plugins.osgi.OsgiPluginConvention;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.bundling.Jar;

public class OsgiPlugin
implements Plugin<Project> {
    public void apply(final Project project) {
        project.getPluginManager().apply(JavaBasePlugin.class);
        final OsgiPluginConvention osgiConvention = new OsgiPluginConvention((ProjectInternal)project);
        project.getConvention().getPlugins().put("osgi", osgiConvention);
        project.getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                Sync prepareOsgiClasses = (Sync)project.getTasks().create("osgiClasses", Sync.class);
                FileCollection classes = ((SourceSet)((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName("main")).getOutput().getClassesDirs();
                File singleClassesDirectory = new File(project.getBuildDir(), "osgi-classes");
                prepareOsgiClasses.setDescription("Prepares a single classes directory required for OSGi analysis.");
                prepareOsgiClasses.from(new Object[]{classes});
                prepareOsgiClasses.into((Object)singleClassesDirectory);
                Jar jarTask = (Jar)project.getTasks().getByName("jar");
                jarTask.dependsOn(new Object[]{prepareOsgiClasses});
                OsgiManifest osgiManifest = osgiConvention.osgiManifest();
                osgiManifest.setClassesDir(singleClassesDirectory);
                osgiManifest.setClasspath((FileCollection)project.getConfigurations().getByName("runtimeClasspath"));
                jarTask.setManifest((Manifest)osgiManifest);
            }
        });
    }
}

