/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.util;

import com.ctc.wstx.api.WstxInputProperties;
import com.ctc.wstx.stax.WstxInputFactory;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import javax.xml.stream.XMLInputFactory;

public class DataExchange {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static XmlMapper xmlMapper;

    public static <T> T parseJson(File file, Class<T> clazz) {
        return DataExchange.parseWithMapper(JSON_MAPPER, file, clazz);
    }

    public static <T> T parseJson(String str, Class<T> clazz) {
        return DataExchange.parseWithMapper(JSON_MAPPER, str, clazz);
    }

    public static <T> T parseYaml(File file, Class<T> clazz) {
        return DataExchange.parseWithMapper(YAML_MAPPER, file, clazz);
    }

    public static <T> T parseYaml(String s, Class<T> clazz) {
        return DataExchange.parseWithMapper(YAML_MAPPER, s, clazz);
    }

    public static <T> T parseXml(File file, Class<T> clazz) {
        return DataExchange.parseWithMapper((ObjectMapper)xmlMapper, file, clazz);
    }

    private static <T> T parseWithMapper(ObjectMapper mapper, String s, Class<T> clazz) {
        try {
            return (T)mapper.readValue(s, clazz);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static <T> T parseWithMapper(ObjectMapper mapper, File file, Class<T> clazz) {
        try {
            return (T)mapper.readValue(file, clazz);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String toYaml(Object model) {
        try {
            return YAML_MAPPER.writeValueAsString(model);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String toJson(Object model) {
        try {
            return JSON_MAPPER.writeValueAsString(model);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static {
        WstxInputFactory inputFactory = new WstxInputFactory();
        inputFactory.getConfig().setInputParsingMode(WstxInputProperties.PARSING_MODE_DOCUMENTS);
        xmlMapper = new XmlMapper((XMLInputFactory)inputFactory);
    }
}

