/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.util;

import com.github.blindpirate.gogradle.util.ExceptionHandler;
import groovy.lang.Closure;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.gradle.util.ConfigureUtil;
import org.joor.Reflect;
import org.joor.ReflectException;

public class ConfigureUtils {
    public static <T> T configureByMapQuietly(Map<?, ?> properties, T delegate) {
        if (properties.isEmpty()) {
            return delegate;
        }
        properties.forEach((key, value) -> {
            String setter = "set" + ConfigureUtils.property(key.toString());
            if (ConfigureUtils.hasSetter(delegate, setter)) {
                Reflect.on((Object)delegate).call(setter, new Object[]{value});
            } else {
                try {
                    Reflect.on((Object)delegate).set(key.toString(), value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return delegate;
    }

    private static <T> boolean hasSetter(T target, String setterName) {
        ArrayList<Method> methods = new ArrayList<Method>();
        Class<?> clazz = target.getClass();
        do {
            methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        } while ((clazz = clazz.getSuperclass()) != Object.class);
        return methods.stream().anyMatch(method -> method.getName().equals(setterName) && method.getParameterCount() == 1);
    }

    public static boolean match(Map<String, Object> properties, Object target) {
        return properties.entrySet().stream().allMatch(entry -> ConfigureUtils.entryMatch(entry, target));
    }

    private static boolean entryMatch(Map.Entry<String, Object> propertyEntry, Object target) {
        String name = propertyEntry.getKey();
        Object value = propertyEntry.getValue();
        Optional<Object> result = ConfigureUtils.getPojoValue(target, name);
        return result.filter(o -> Objects.equals(value, o)).isPresent();
    }

    private static Optional<Object> getPojoValue(Object target, String name) {
        try {
            return Optional.of(Reflect.on((Object)target).call("get" + ConfigureUtils.property(name)).get());
        }
        catch (Exception e) {
            try {
                return Optional.of(Reflect.on((Object)target).call("is" + ConfigureUtils.property(name)).get());
            }
            catch (ReflectException e1) {
                if (ExceptionHandler.getRootCause(e1) instanceof NoSuchMethodException) {
                    return Optional.empty();
                }
                throw e1;
            }
        }
    }

    private static String property(String string) {
        int length = string.length();
        if (length == 0) {
            return "";
        }
        if (length == 1) {
            return string.toUpperCase();
        }
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static void configure(Object target, Closure<?> configureClosure) {
        ConfigureUtil.configure(configureClosure, (Object)target);
    }
}

