/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.task.go;

import com.github.blindpirate.gogradle.GolangPluginSetting;
import com.github.blindpirate.gogradle.build.BuildManager;
import com.github.blindpirate.gogradle.common.GoSourceCodeFilter;
import com.github.blindpirate.gogradle.common.LineCollector;
import com.github.blindpirate.gogradle.crossplatform.GoBinaryManager;
import com.github.blindpirate.gogradle.task.AbstractGolangTask;
import com.github.blindpirate.gogradle.task.GolangTaskContainer;
import com.github.blindpirate.gogradle.task.go.GoTestStdoutExtractor;
import com.github.blindpirate.gogradle.task.go.PackageTestResult;
import com.github.blindpirate.gogradle.unsafe.GradleInternalAPI;
import com.github.blindpirate.gogradle.util.CollectionUtils;
import com.github.blindpirate.gogradle.util.IOUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.gradle.api.Incubating;
import org.gradle.api.internal.tasks.options.Option;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class GoTest
extends AbstractGolangTask {
    private static final Logger LOGGER = Logging.getLogger(GoTest.class);
    private static final String REWRITE_SCRIPT_RESOURCE = "test/rewrite.html";
    private static final String TEST_REPORT_DIR = ".gogradle/reports/test";
    @Inject
    private GolangPluginSetting setting;
    @Inject
    private GoTestStdoutExtractor extractor;
    @Inject
    private BuildManager buildManager;
    @Inject
    private GoBinaryManager goBinaryManager;
    private List<String> testNamePattern;
    private boolean generateCoverageProfile = true;
    private boolean continueOnFailure;
    private Map<String, String> environment = new HashMap<String, String>();

    public GoTest() {
        this.setDescription("Run all tests.");
        this.dependsOn(new Object[]{GolangTaskContainer.VENDOR_TASK_NAME});
    }

    public void environment(String key, String value) {
        this.environment.put(key, value);
    }

    public void environment(Map<String, String> map) {
        this.environment.putAll(map);
    }

    @Deprecated
    public void setContinueWhenFail(boolean continueOnFailure) {
        LOGGER.warn("continueWhenFail is deprecated, please use continueOnFailure instead.");
        this.continueOnFailure = continueOnFailure;
    }

    public void setContinueOnFailure(boolean continueOnFailure) {
        this.continueOnFailure = continueOnFailure;
    }

    public void setGenerateCoverageProfile(boolean generateCoverageProfile) {
        this.generateCoverageProfile = generateCoverageProfile;
    }

    @Option(option="tests", description="Sets test class or method name to be included, '*' is supported.")
    @Incubating
    public GoTest setTestNamePattern(List<String> testNamePattern) {
        this.testNamePattern = testNamePattern;
        return this;
    }

    @TaskAction
    public void run() {
        this.setGogradleGlobalContext();
        this.prepareCoverageProfileDir();
        List<TestClassResult> testResults = this.doTest();
        this.generateTestReport(testResults);
        this.rewritePackageName(this.getReportDir());
        this.reportErrorIfNecessary(testResults, this.getReportDir());
    }

    @Input
    @Optional
    List<String> getTestNamePattern() {
        return this.testNamePattern;
    }

    @Input
    String getGoVersion() {
        return this.goBinaryManager.getGoVersion();
    }

    @Input
    List<String> getBuildTags() {
        return this.setting.getBuildTags();
    }

    @InputFiles
    Collection<File> getAllGoFiles() {
        return GoSourceCodeFilter.filterGoFiles(this.getProjectDir(), GoSourceCodeFilter.SourceSetType.PROJECT_TEST_AND_VENDOR_BUILD_FILES);
    }

    @OutputDirectory
    File getReportDir() {
        return new File(this.getProjectDir(), TEST_REPORT_DIR);
    }

    @OutputDirectory
    File getCoverageDir() {
        return new File(this.getProjectDir(), ".gogradle/reports/coverage/profiles");
    }

    private Map<File, List<File>> groupByParentDir(Collection<File> files) {
        return files.stream().collect(Collectors.groupingBy(File::getParentFile));
    }

    private List<File> getAllNonTestGoFiles(File dir) {
        return IOUtils.safeListFiles(dir).stream().filter(file -> file.getName().endsWith(".go")).filter(file -> !StringUtils.fileNameStartsWithDotOrUnderline(file)).filter(file -> !StringUtils.fileNameEndsWithAny(file, "_test.go")).filter(File::isFile).collect(Collectors.toList());
    }

    private String dirToImportPath(File dir) {
        Path relativeToProjectRoot = this.getProjectDir().toPath().relativize(dir.toPath());
        Path importPath = Paths.get(this.setting.getPackagePath(), new String[0]).resolve(relativeToProjectRoot);
        return StringUtils.toUnixString(importPath);
    }

    private void generateTestReport(List<TestClassResult> testResults) {
        GradleInternalAPI.renderTestReport(testResults, this.getReportDir());
    }

    private List<TestClassResult> doTest() {
        ArrayList<TestClassResult> ret = new ArrayList<TestClassResult>();
        Map<File, List<File>> parentDirToTestFiles = this.determineTestPattern();
        parentDirToTestFiles.forEach((parentDir, testFiles) -> {
            String packageImportPath = this.dirToImportPath((File)parentDir);
            PackageTestResult result = this.doSingleTest(packageImportPath, (List<File>)testFiles);
            List<TestClassResult> resultOfSinglePackage = this.extractor.extractTestResult(result);
            this.logResult(packageImportPath, resultOfSinglePackage);
            ret.addAll(resultOfSinglePackage);
        });
        return ret;
    }

    private Map<File, List<File>> determineTestPattern() {
        if (CollectionUtils.isEmpty(this.testNamePattern)) {
            Collection<File> allTestFiles = GoSourceCodeFilter.filterGoFiles(this.getProjectDir(), GoSourceCodeFilter.SourceSetType.PROJECT_TEST_FILES_ONLY);
            return this.groupByParentDir(allTestFiles);
        }
        Collection<File> filesMatchingPatterns = GoSourceCodeFilter.filterTestsMatchingPattern(this.getProjectDir(), this.testNamePattern);
        if (filesMatchingPatterns.isEmpty()) {
            LOGGER.quiet("No tests matching " + this.testNamePattern.stream().collect(Collectors.joining("/")) + ", skip.");
            return Collections.emptyMap();
        }
        LOGGER.quiet("Found " + filesMatchingPatterns.size() + " files to test.");
        Map<File, List<File>> parentDirToFiles = this.groupByParentDir(filesMatchingPatterns);
        parentDirToFiles.forEach((parentDir, tests) -> tests.addAll(this.getAllNonTestGoFiles((File)parentDir)));
        return parentDirToFiles;
    }

    private void reportErrorIfNecessary(List<TestClassResult> results, File reportDir) {
        int totalFailureCount = results.stream().mapToInt(TestClassResult::getFailuresCount).sum();
        String message = "There are " + totalFailureCount + " failed tests. Please see " + StringUtils.toUnixString(new File(reportDir, "index.html")) + " for more details.";
        if (this.continueOnFailure) {
            LOGGER.error(message);
        } else if (totalFailureCount > 0) {
            throw new IllegalStateException(message);
        }
    }

    private void prepareCoverageProfileDir() {
        File coverageDir = new File(this.getProjectDir(), ".gogradle/reports/coverage/profiles");
        IOUtils.forceMkdir(coverageDir);
        IOUtils.clearDirectory(coverageDir);
    }

    private PackageTestResult doSingleTest(String importPath, List<File> testFiles) {
        List<Object> args;
        LineCollector lineCollector = new LineCollector();
        List<Object> list = args = this.isCommandLineArguments() ? CollectionUtils.asStringList("test", "-v", IOUtils.collectFileNames(testFiles)) : Lists.newArrayList((Object[])new String[]{"test", "-v", importPath});
        if (this.generateCoverageProfile) {
            File profilesPath = new File(this.getProjectDir(), ".gogradle/reports/coverage/profiles/" + IOUtils.encodeInternally(importPath) + ".out");
            args.add("-coverprofile=" + StringUtils.toUnixString(profilesPath.getAbsolutePath()));
        }
        Consumer<String> consumer = this.determineLineConsumer(lineCollector, importPath);
        int retCode = this.buildManager.go((List<String>)args, this.environment, consumer, consumer, true);
        return PackageTestResult.builder().withPackagePath(importPath).withStdout(lineCollector.getLines()).withTestFiles(testFiles).withCode(retCode).build();
    }

    private Consumer<String> determineLineConsumer(LineCollector lineCollector, String importPath) {
        if (!LOGGER.isInfoEnabled()) {
            return lineCollector;
        }
        if (this.isCommandLineArguments()) {
            LOGGER.info("Result:");
        } else {
            LOGGER.info("Result of package {}:", (Object)importPath);
        }
        return lineCollector.andThen(arg_0 -> ((Logger)LOGGER).info(arg_0));
    }

    private boolean isCommandLineArguments() {
        return !CollectionUtils.isEmpty(this.testNamePattern);
    }

    private void logResult(String packagePath, List<TestClassResult> resultOfSinglePackage) {
        int successCount = this.successCount(resultOfSinglePackage);
        int failureCount = this.failureCount(resultOfSinglePackage);
        LOGGER.quiet("Test for {} finished, {} completed, {} failed", new Object[]{packagePath, successCount + failureCount, failureCount});
    }

    private int successCount(List<TestClassResult> results) {
        return results.stream().mapToInt(result -> result.getResults().size() - result.getFailuresCount()).sum();
    }

    private int failureCount(List<TestClassResult> results) {
        return results.stream().mapToInt(TestClassResult::getFailuresCount).sum();
    }

    private void rewritePackageName(File reportDir) {
        Collection<File> htmlFiles = IOUtils.filterFilesRecursively(reportDir, (IOFileFilter)new SuffixFileFilter(".html"), TrueFileFilter.INSTANCE);
        String rewriteScript = IOUtils.toString(GoTest.class.getClassLoader().getResourceAsStream(REWRITE_SCRIPT_RESOURCE));
        htmlFiles.forEach(htmlFile -> {
            String content = IOUtils.toString(htmlFile);
            content = content.replace("</body>", "</body>" + rewriteScript);
            IOUtils.write(htmlFile, content);
        });
    }
}

