/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.crossplatform;

import com.github.blindpirate.gogradle.GolangPluginSetting;
import com.github.blindpirate.gogradle.core.cache.GlobalCacheManager;
import com.github.blindpirate.gogradle.crossplatform.Arch;
import com.github.blindpirate.gogradle.crossplatform.GoBinaryManager;
import com.github.blindpirate.gogradle.crossplatform.Os;
import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.util.CompressUtils;
import com.github.blindpirate.gogradle.util.HttpUtils;
import com.github.blindpirate.gogradle.util.IOUtils;
import com.github.blindpirate.gogradle.util.ProcessUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.tuple.Pair;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

@Singleton
public class DefaultGoBinaryManager
implements GoBinaryManager {
    private static final Logger LOGGER = Logging.getLogger(DefaultGoBinaryManager.class);
    public static final String FILENAME = "go${version}.${os}-${arch}${extension}";
    private static final String NEWEST_VERSION_URL = "http://gogradle.oss-cn-hongkong.aliyuncs.com/newest-stable-go-version.txt";
    private static final Pattern GO_VERSION_OUTPUT_REGEX = Pattern.compile("go version go((\\d|\\.)+) .+");
    private static final String IGNORE_LOCAL = "IGNORE_LOCAL";
    private final GolangPluginSetting setting;
    private final GlobalCacheManager globalCacheManager;
    private final HttpUtils httpUtils;
    private final ProcessUtils processUtils;
    private boolean resolved = false;
    private Path binaryPath;
    private Path goroot;
    private String goVersion;

    @Inject
    public DefaultGoBinaryManager(GolangPluginSetting setting, GlobalCacheManager globalCacheManager, HttpUtils httpUtils, ProcessUtils processUtils) {
        this.setting = setting;
        this.globalCacheManager = globalCacheManager;
        this.httpUtils = httpUtils;
        this.processUtils = processUtils;
    }

    @Override
    public Path getBinaryPath() {
        this.resolveIfNecessary();
        return this.binaryPath;
    }

    @Override
    public Path getGoroot() {
        this.resolveIfNecessary();
        return this.goroot;
    }

    @Override
    public String getGoVersion() {
        this.resolveIfNecessary();
        return this.goVersion;
    }

    private void resolveIfNecessary() {
        if (this.resolved) {
            return;
        }
        this.determineGoBinaryAndVersion();
        this.goroot = this.setting.getGoRoot() != null ? Paths.get(this.setting.getGoRoot(), new String[0]) : IOUtils.toRealPath(this.binaryPath).resolve("../..").normalize();
        this.resolved = true;
    }

    private void determineGoBinaryAndVersion() {
        if (IGNORE_LOCAL.equals(this.setting.getGoExecutable())) {
            this.fetchGoDistribution();
        } else if ("go".equals(this.setting.getGoExecutable())) {
            Optional<Pair<Path, String>> binPathAndVersionOnHost = this.findGoBinAndVersionHost();
            if (binPathAndVersionOnHost.isPresent()) {
                Path goBinPath = (Path)binPathAndVersionOnHost.get().getLeft();
                String version = (String)binPathAndVersionOnHost.get().getRight();
                if (this.versionMatch(version)) {
                    this.useGoExecutableOnHost(goBinPath, version);
                } else {
                    this.fetchSpecifiedVersion(this.setting.getGoVersion());
                }
            } else {
                this.fetchGoDistribution();
            }
        } else {
            Optional<Pair<Path, String>> pathAndVersion = this.tryGivenGoExecutable();
            Assert.isTrue(pathAndVersion.isPresent(), "Cannot execute given go binary: " + this.setting.getGoExecutable());
            Assert.isTrue(this.versionMatch((String)pathAndVersion.get().getRight()), "Version not match: required is " + this.setting.getGoVersion() + ", given is " + (String)pathAndVersion.get().getRight());
            this.useGoExecutableOnHost((Path)pathAndVersion.get().getLeft(), (String)pathAndVersion.get().getRight());
        }
    }

    private void fetchGoDistribution() {
        if (this.setting.getGoVersion() == null) {
            this.fetchNewestStableVersion();
        } else {
            this.fetchSpecifiedVersion(this.setting.getGoVersion());
        }
    }

    private boolean versionMatch(String actualVersion) {
        return this.setting.getGoVersion() == null || this.setting.getGoVersion().equals(actualVersion);
    }

    private void useGoExecutableOnHost(Path goBinPathOnHost, String versionOnHost) {
        LOGGER.quiet("Found go {} in {}, use it.", new Object[]{versionOnHost, goBinPathOnHost});
        this.binaryPath = goBinPathOnHost;
        this.goVersion = versionOnHost;
    }

    private void fetchNewestStableVersion() {
        try {
            String newestStableVersion = this.httpUtils.get(NEWEST_VERSION_URL).trim();
            this.fetchSpecifiedVersion(newestStableVersion);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Optional<Pair<Path, String>> tryGivenGoExecutable() {
        Path givenGoExecutablePath = Paths.get(this.setting.getGoExecutable(), new String[0]);
        Optional<Pair<Path, String>> ret = this.tryInvokeGoVersion(givenGoExecutablePath);
        Assert.isTrue(ret.isPresent(), "Failed to run given go executable: " + this.setting.getGoExecutable());
        return ret;
    }

    private Optional<Pair<Path, String>> findGoBinAndVersionHost() {
        String[] paths;
        String PATH = System.getenv("PATH");
        for (String path : paths = StringUtils.splitAndTrim(PATH, File.pathSeparator)) {
            Path goExecutablePath = Paths.get(path, new String[0]).resolve("go" + Os.getHostOs().exeExtension());
            Optional<Pair<Path, String>> pathAndVersion = this.tryInvokeGoVersion(goExecutablePath);
            if (!pathAndVersion.isPresent()) continue;
            return pathAndVersion;
        }
        return Optional.empty();
    }

    private Optional<Pair<Path, String>> tryInvokeGoVersion(Path executablePath) {
        try {
            Process process = this.processUtils.run(executablePath.toAbsolutePath().toString(), "version");
            ProcessUtils.ProcessResult result = this.processUtils.getResult(process);
            Matcher m = GO_VERSION_OUTPUT_REGEX.matcher(result.getStdout());
            if (m.find()) {
                Pair binaryPathAndVersion = Pair.of((Object)executablePath, (Object)m.group(1));
                return Optional.of(binaryPathAndVersion);
            }
            return Optional.empty();
        }
        catch (Exception e) {
            LOGGER.debug("Encountered exception when running go version via: " + executablePath.toAbsolutePath(), (Throwable)e);
            return Optional.empty();
        }
    }

    private void fetchSpecifiedVersion(String version) {
        this.goroot = this.globalCacheManager.getGlobalGoBinCacheDir(version).toPath().resolve("go");
        this.goVersion = version;
        this.binaryPath = this.goroot.resolve("bin/go" + Os.getHostOs().exeExtension());
        if (!Files.exists(this.binaryPath, new LinkOption[0])) {
            LOGGER.quiet("Start downloading go {}.", new Object[]{version});
            this.downloadSpecifiedVersion(version);
            this.addXPermissionToAllDescendant(this.goroot.resolve("bin"));
            this.addXPermissionToAllDescendant(this.goroot.resolve("pkg/tool"));
        }
    }

    private void addXPermissionToAllDescendant(Path path) {
        FileUtils.listFiles((File)path.toFile(), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE).stream().map(File::toPath).forEach(IOUtils::chmodAddX);
    }

    private void downloadSpecifiedVersion(String version) {
        Path archivePath = this.downloadArchive(version);
        CompressUtils.decompressZipOrTarGz(archivePath.toFile(), this.globalCacheManager.getGlobalGoBinCacheDir(version));
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private Path downloadArchive(String version) {
        String url = this.injectVariables(this.setting.getGoBinaryDownloadTemplate(), version);
        String archiveFileName = this.injectVariables(FILENAME, version);
        File goBinaryCachePath = this.globalCacheManager.getGlobalGoBinCacheDir(archiveFileName);
        IOUtils.forceMkdir(goBinaryCachePath.getParentFile());
        LOGGER.warn("downloading {} -> {}", (Object)url, (Object)goBinaryCachePath.getAbsolutePath());
        try {
            this.httpUtils.download(url, goBinaryCachePath.toPath());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return goBinaryCachePath.toPath();
    }

    private String injectVariables(String template, String version) {
        String ret = template.replace("${version}", version);
        ret = ret.replace("${os}", Os.getHostOs().toString());
        ret = ret.replace("${arch}", Arch.getHostArch().toString());
        ret = ret.replace("${extension}", Os.getHostOs().archiveExtension());
        return ret;
    }
}

