/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.tree;

import com.github.blindpirate.gogradle.core.dependency.GolangDependencySet;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import com.github.blindpirate.gogradle.util.Assert;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DependencyTreeNode
implements Comparable<DependencyTreeNode>,
Serializable {
    private String name;
    private boolean star;
    private ResolvedDependency originalDependency;
    private ResolvedDependency finalDependency;
    private List<DependencyTreeNode> children = new ArrayList<DependencyTreeNode>();

    private DependencyTreeNode(ResolvedDependency originalDependency, ResolvedDependency finalDependency, boolean star) {
        this.originalDependency = originalDependency;
        this.finalDependency = finalDependency;
        this.name = originalDependency.getName();
        this.star = star;
    }

    public static DependencyTreeNode withOrignalAndFinal(ResolvedDependency original, ResolvedDependency finalResult, boolean star) {
        return new DependencyTreeNode(original, finalResult, star);
    }

    public DependencyTreeNode addChild(DependencyTreeNode child) {
        this.children.add(child);
        Collections.sort(this.children);
        return this;
    }

    public String output() {
        return this.print("", true, true);
    }

    private String print(String prefix, boolean isTail, boolean isRoot) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(this.branch(isRoot, isTail)).append(this.format(isRoot)).append("\n");
        String prefixOfChildren = prefix + this.padding(isRoot, isTail);
        for (int i = 0; i < this.children.size() - 1; ++i) {
            sb.append(this.children.get(i).print(prefixOfChildren, false, false));
        }
        if (this.children.size() > 0) {
            sb.append(this.children.get(this.children.size() - 1).print(prefixOfChildren, true, false));
        }
        return sb.toString();
    }

    private String padding(boolean isRoot, boolean isTail) {
        if (isRoot) {
            return "";
        }
        return isTail ? "    " : "|   ";
    }

    private String branch(boolean isRoot, boolean isTail) {
        if (isRoot) {
            return "";
        }
        return isTail ? "\\-- " : "|-- ";
    }

    private String format(boolean isRoot) {
        if (isRoot) {
            return this.name;
        }
        if (this.originalDependency.equals(this.finalDependency)) {
            return this.withName() + this.star();
        }
        return this.withArrow() + this.star();
    }

    private String star() {
        return this.star ? " (*)" : "";
    }

    private String withArrow() {
        return this.finalDependency.getName() + ":" + this.formatVersion(this.originalDependency) + " -> " + this.formatVersion(this.finalDependency);
    }

    private String formatVersion(ResolvedDependency dependency) {
        if (dependency.getSubpackages().contains("...")) {
            return dependency.formatVersion();
        }
        return dependency.formatVersion() + " " + dependency.getSubpackages();
    }

    private String withName() {
        return this.finalDependency.getName() + ":" + this.formatVersion(this.finalDependency);
    }

    public GolangDependencySet flatten() {
        GolangDependencySet result = new GolangDependencySet();
        this.dfs(result, 0);
        return result;
    }

    private void dfs(GolangDependencySet result, int depth) {
        Assert.isTrue(depth < 100);
        for (DependencyTreeNode child : this.children) {
            result.add(child.finalDependency);
            child.dfs(result, depth + 1);
        }
    }

    @Override
    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
    public int compareTo(DependencyTreeNode o) {
        return this.name.compareTo(o.name);
    }

    public String toString() {
        return "" + this.originalDependency + " -> " + this.finalDependency;
    }
}

