/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.produce;

import com.github.blindpirate.gogradle.core.dependency.GolangDependencySet;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import com.github.blindpirate.gogradle.core.dependency.produce.FirstPassVendorDirectoryVisitor;
import com.github.blindpirate.gogradle.core.dependency.produce.SecondPassVendorDirectoryVisitor;
import com.github.blindpirate.gogradle.core.pack.PackagePathResolver;
import com.github.blindpirate.gogradle.util.IOUtils;
import java.io.File;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class VendorDependencyFactory {
    public static final String VENDOR_DIRECTORY = "vendor";
    private final PackagePathResolver packagePathResolver;

    @Inject
    public VendorDependencyFactory(PackagePathResolver packagePathResolver) {
        this.packagePathResolver = packagePathResolver;
    }

    public GolangDependencySet produce(ResolvedDependency dependency, File rootDir) {
        if (this.vendorDirExist(rootDir)) {
            return this.resolveVendor(dependency, rootDir);
        }
        return GolangDependencySet.empty();
    }

    private GolangDependencySet resolveVendor(ResolvedDependency dependency, File rootDir) {
        Path vendorPath = this.vendorPath(rootDir);
        FirstPassVendorDirectoryVisitor firstPassVistor = new FirstPassVendorDirectoryVisitor(vendorPath, this.packagePathResolver);
        IOUtils.walkFileTreeSafely(vendorPath, firstPassVistor);
        SecondPassVendorDirectoryVisitor secondPassVisitor = new SecondPassVendorDirectoryVisitor(dependency, vendorPath, this.packagePathResolver);
        IOUtils.walkFileTreeSafely(vendorPath, secondPassVisitor);
        return secondPassVisitor.getDependencies();
    }

    private boolean vendorDirExist(File rootDir) {
        return new File(rootDir, VENDOR_DIRECTORY).exists();
    }

    private Path vendorPath(File rootDir) {
        return rootDir.toPath().resolve(VENDOR_DIRECTORY);
    }
}

