/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.parse;

import com.github.blindpirate.gogradle.core.dependency.parse.NotationConverter;
import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.util.MapUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.util.Map;
import javax.inject.Singleton;

@Singleton
public class GitMercurialNotationConverter
implements NotationConverter {
    private static final String TAG_SEPERATOR = "@";
    private static final String COMMIT_SEPERATOR = "#";

    @Override
    public Map<String, Object> convert(String notation) {
        if (notation.contains(TAG_SEPERATOR)) {
            return this.buildByTag(notation);
        }
        if (notation.contains(COMMIT_SEPERATOR)) {
            return this.buildByCommit(notation);
        }
        return this.buildByName(notation);
    }

    private Map<String, Object> buildByName(String notation) {
        return MapUtils.asMap("name", notation);
    }

    private Map<String, Object> buildByCommit(String notation) {
        String[] array = StringUtils.splitAndTrim(notation, COMMIT_SEPERATOR);
        Assert.isTrue(array.length == 2, "Invalid notation:" + notation);
        String name = array[0];
        String commit = array[1];
        return MapUtils.asMap("name", name, "commit", commit);
    }

    private Map<String, Object> buildByTag(String notation) {
        int indexOfAt = notation.indexOf(TAG_SEPERATOR);
        String name = notation.substring(0, indexOfAt);
        String tag = notation.substring(indexOfAt + 1);
        return MapUtils.asMap("name", name, "tag", tag);
    }
}

