/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.parse;

import com.github.blindpirate.gogradle.core.GolangPackage;
import com.github.blindpirate.gogradle.core.VcsGolangPackage;
import com.github.blindpirate.gogradle.core.dependency.parse.NotationConverter;
import com.github.blindpirate.gogradle.core.pack.PackagePathResolver;
import com.github.blindpirate.gogradle.util.MapUtils;
import com.github.blindpirate.gogradle.util.logging.DebugLog;
import com.github.blindpirate.gogradle.vcs.VcsType;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DefaultNotationConverter
implements NotationConverter {
    private final PackagePathResolver packagePathResolver;

    @Inject
    public DefaultNotationConverter(PackagePathResolver packagePathResolver) {
        this.packagePathResolver = packagePathResolver;
    }

    @Override
    @DebugLog
    public Map<String, Object> convert(String notation) {
        String packagePath = this.extractPackagePath(notation);
        GolangPackage packageInfo = this.packagePathResolver.produce(packagePath).get();
        if (packageInfo instanceof VcsGolangPackage) {
            VcsType vcsType = ((VcsGolangPackage)VcsGolangPackage.class.cast(packageInfo)).getVcsType();
            return vcsType.getNotationConverter().convert(notation);
        }
        return MapUtils.asMap("name", notation);
    }

    private String extractPackagePath(String notation) {
        for (int i = 0; i < notation.length(); ++i) {
            char c = notation.charAt(i);
            if (c != '#' && c != '@') continue;
            return notation.substring(0, i);
        }
        return notation;
    }
}

