/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.parse;

import com.github.blindpirate.gogradle.core.GolangPackage;
import com.github.blindpirate.gogradle.core.GolangRepository;
import com.github.blindpirate.gogradle.core.LocalDirectoryGolangPackage;
import com.github.blindpirate.gogradle.core.ResolvableGolangPackage;
import com.github.blindpirate.gogradle.core.UnrecognizedGolangPackage;
import com.github.blindpirate.gogradle.core.VcsGolangPackage;
import com.github.blindpirate.gogradle.core.dependency.NotationDependency;
import com.github.blindpirate.gogradle.core.dependency.UnrecognizedNotationDependency;
import com.github.blindpirate.gogradle.core.dependency.parse.DirMapNotationParser;
import com.github.blindpirate.gogradle.core.dependency.parse.MapNotationParser;
import com.github.blindpirate.gogradle.core.dependency.parse.VendorMapNotationParser;
import com.github.blindpirate.gogradle.core.exceptions.DependencyResolutionException;
import com.github.blindpirate.gogradle.core.pack.DefaultPackagePathResolver;
import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.util.MapUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import com.github.blindpirate.gogradle.vcs.VcsType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DefaultMapNotationParser
implements MapNotationParser {
    private final DirMapNotationParser dirMapNotationParser;
    private final VendorMapNotationParser vendorMapNotationParser;
    private final DefaultPackagePathResolver packagePathResolver;

    @Inject
    public DefaultMapNotationParser(DirMapNotationParser dirMapNotationParser, VendorMapNotationParser vendorMapNotationParser, DefaultPackagePathResolver packagePathResolver) {
        this.dirMapNotationParser = dirMapNotationParser;
        this.vendorMapNotationParser = vendorMapNotationParser;
        this.packagePathResolver = packagePathResolver;
    }

    @Override
    public NotationDependency parse(Map<String, Object> notation) {
        Assert.isTrue(notation.containsKey("name"), "Name must be specified!");
        GolangPackage pkg = this.determinePackage(notation);
        if (pkg instanceof ResolvableGolangPackage) {
            String rootPathString = ((ResolvableGolangPackage)ResolvableGolangPackage.class.cast(pkg)).getRootPathString();
            notation.put("name", rootPathString);
            notation.put("package", ((ResolvableGolangPackage)ResolvableGolangPackage.class.cast(pkg)).resolve(rootPathString).get());
        } else {
            notation.put("package", pkg);
        }
        if (notation.containsKey("dir") || pkg instanceof LocalDirectoryGolangPackage) {
            return this.dirMapNotationParser.parse(notation);
        }
        if (notation.containsKey("vendorPath")) {
            return this.vendorMapNotationParser.parse(notation);
        }
        if (pkg instanceof VcsGolangPackage) {
            return this.parseVcsPackage(notation, (VcsGolangPackage)pkg);
        }
        if (pkg instanceof UnrecognizedGolangPackage) {
            return UnrecognizedNotationDependency.of((UnrecognizedGolangPackage)pkg);
        }
        throw DependencyResolutionException.cannotParseNotation(notation);
    }

    private GolangPackage determinePackage(Map<String, Object> notation) {
        String packagePath = MapUtils.getString(notation, "name");
        if (notation.containsKey("dir")) {
            LocalDirectoryGolangPackage pkg = LocalDirectoryGolangPackage.of(packagePath, packagePath, MapUtils.getString(notation, "dir"));
            this.packagePathResolver.updateCache(packagePath, pkg);
            return pkg;
        }
        if (notation.containsKey("url") || notation.containsKey("urls")) {
            VcsGolangPackage pkg = this.adaptAsVcsPackage(notation, packagePath);
            this.packagePathResolver.updateCache(packagePath, pkg);
            return pkg;
        }
        return this.packagePathResolver.produce(packagePath).get();
    }

    private VcsGolangPackage adaptAsVcsPackage(Map<String, Object> notation, String rootPath) {
        List urls = notation.containsKey("url") ? Collections.singletonList(MapUtils.getString(notation, "url")) : MapUtils.getValue(notation, "urls", List.class);
        GolangRepository repository = GolangRepository.newSubstitutedRepository(this.determineVcs(notation), urls);
        return VcsGolangPackage.builder().withRepository(repository).withPath(rootPath).withRootPath(rootPath).build();
    }

    private NotationDependency parseVcsPackage(Map<String, Object> notation, VcsGolangPackage pkg) {
        this.verifyVcs(notation, pkg);
        return pkg.getVcsType().getService(MapNotationParser.class).parse(notation);
    }

    private VcsType determineVcs(Map<String, Object> notation) {
        String vcs = MapUtils.getString(notation, "vcs");
        if (vcs == null) {
            notation.put("vcs", VcsType.GIT.getName());
            return VcsType.GIT;
        }
        return VcsType.of(vcs).get();
    }

    private void verifyVcs(Map<String, Object> notation, VcsGolangPackage pkg) {
        String declaredVcs = MapUtils.getString(notation, "vcs");
        if (StringUtils.isNotBlank(declaredVcs)) {
            String actualVcs = pkg.getVcsType().getName();
            Assert.isTrue(declaredVcs.equals(actualVcs), "Vcs type not match: declared is " + declaredVcs + " but actual is " + actualVcs);
        }
    }
}

