/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core;

import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.vcs.VcsType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.Closure;
import java.util.Optional;
import org.codehaus.groovy.runtime.InvokerHelper;

@SuppressFBWarnings(value={"UMAC_UNCALLABLE_METHOD_OF_ANONYMOUS_CLASS"})
public class GolangRepositoryPattern {
    public static final String EMPTY_DIR = "GOGRADLE_EMPTY_DIR";
    private boolean incomplete;
    private Object pathPattern;
    private Object urlSubstitution;
    private Object dir;
    private VcsType vcsType = VcsType.GIT;

    public void all() {
        Assert.isNull(this.pathPattern);
        this.pathPattern = new Object(){

            boolean isCase(Object candidate) {
                return true;
            }
        };
    }

    public void root(Object pathPattern) {
        Assert.isNull(this.pathPattern);
        this.pathPattern = pathPattern;
    }

    public void incomplete(Object pathPattern) {
        Assert.isNull(this.pathPattern);
        this.pathPattern = pathPattern;
        this.incomplete = true;
    }

    public boolean isIncomplete() {
        return this.incomplete;
    }

    public void dir(Object urlOrClosure) {
        this.checkIncomplete();
        this.dir = urlOrClosure;
    }

    private void checkIncomplete() {
        if (this.incomplete) {
            throw new UnsupportedOperationException("Not supported for incomplete path!");
        }
    }

    public void url(Object urlOrClosure) {
        this.checkIncomplete();
        this.urlSubstitution = urlOrClosure;
    }

    public void vcs(String vcs) {
        this.checkIncomplete();
        Optional<VcsType> vcsOptional = VcsType.of(vcs);
        Assert.isTrue(vcsOptional.isPresent(), "Unknown vcs type: " + vcs);
        this.vcsType = vcsOptional.get();
    }

    public void emptyDir() {
        this.dir = EMPTY_DIR;
    }

    public VcsType getVcsType() {
        this.checkIncomplete();
        return this.vcsType;
    }

    public String getUrl(String name) {
        this.checkIncomplete();
        return this.substitute(name, this.urlSubstitution);
    }

    private String substitute(String name, Object valueOrClosure) {
        this.checkIncomplete();
        if (valueOrClosure instanceof String) {
            return (String)valueOrClosure;
        }
        if (valueOrClosure instanceof Closure) {
            Closure closure = (Closure)valueOrClosure;
            return Assert.isNotNull(closure.call((Object)name)).toString();
        }
        return null;
    }

    public String getDir(String name) {
        this.checkIncomplete();
        return this.substitute(name, this.dir);
    }

    public boolean match(String name) {
        Assert.isTrue(this.pathPattern != null);
        return (Boolean)InvokerHelper.invokeMethod((Object)this.pathPattern, (String)"isCase", (Object)name);
    }
}

