/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle;

import com.github.blindpirate.gogradle.GogradleGlobal;
import com.github.blindpirate.gogradle.core.mode.BuildMode;
import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.inject.Singleton;

@Singleton
public class GolangPluginSetting {
    private static final String BINARY_URL = "https://storage.googleapis.com/golang/go${version}.${os}-${arch}${extension}";
    private static final String BINARY_URL_GFW = "http://golangtc.com/static/go/${version}/go${version}.${os}-${arch}${extension}";
    private BuildMode buildMode = BuildMode.REPRODUCIBLE;
    private String packagePath;
    private List<String> buildTags = new ArrayList<String>();
    private long globalCacheSecond = 300L;
    private String goVersion;
    private String goExecutable;
    private String goRoot;
    private String goBinaryDownloadTemplate = "https://storage.googleapis.com/golang/go${version}.${os}-${arch}${extension}";
    private Set<String> ignoredPackages = new HashSet<String>();
    private boolean userHasCustomizedIgnoredPackages = false;

    public String getGoRoot() {
        return this.goRoot;
    }

    public void setGoRoot(String goRoot) {
        this.goRoot = goRoot;
    }

    public String getGoExecutable() {
        return this.goExecutable == null ? "go" : this.goExecutable;
    }

    @Nonnull
    public BuildMode getBuildMode() {
        String mode = GogradleGlobal.getMode();
        if (StringUtils.isNotEmpty(mode)) {
            return BuildMode.fromString(mode);
        }
        return this.buildMode;
    }

    public void setBuildMode(@Nonnull String buildMode) {
        this.buildMode = BuildMode.fromString(buildMode);
    }

    public void setBuildMode(BuildMode buildMode) {
        this.buildMode = buildMode;
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public void setPackagePath(String packagePath) {
        this.packagePath = packagePath;
    }

    public List<String> getBuildTags() {
        return this.buildTags;
    }

    public void setBuildTags(List<String> buildTags) {
        buildTags.forEach(t -> Assert.isTrue(!t.contains("\"") && !t.contains("'")));
        this.buildTags = buildTags;
    }

    public String getGoVersion() {
        return this.goVersion;
    }

    public void setGoVersion(String goVersion) {
        this.goVersion = goVersion;
    }

    public void setGoExecutable(String goExecutable) {
        this.goExecutable = goExecutable;
    }

    public void setFuckGfw(boolean fuckGfw) {
        if (fuckGfw) {
            this.fuckGfw();
        } else {
            this.setGoBinaryDownloadTemplate(BINARY_URL);
        }
    }

    public void fuckGfw() {
        this.goBinaryDownloadTemplate = BINARY_URL_GFW;
    }

    public String getGoBinaryDownloadTemplate() {
        return this.goBinaryDownloadTemplate;
    }

    @Deprecated
    public void setGoBinaryDownloadBaseUri(String goBinaryDownloadBaseUri) {
        this.setGoBinaryDownloadBaseUri(goBinaryDownloadBaseUri == null ? null : URI.create(goBinaryDownloadBaseUri));
    }

    @Deprecated
    public void setGoBinaryDownloadBaseUri(URI goBinaryDownloadBaseUri) {
        this.setGoBinaryDownloadTemplate(goBinaryDownloadBaseUri == null ? null : goBinaryDownloadBaseUri.resolve("/") + "go${version}.${os}-${arch}${extension}");
    }

    public void setGoBinaryDownloadTemplate(URI goBinaryDownloadTemplateUri) {
        this.setGoBinaryDownloadTemplate(goBinaryDownloadTemplateUri == null ? null : goBinaryDownloadTemplateUri.toASCIIString());
    }

    public void setGoBinaryDownloadTemplate(String goBinaryDownloadTemplate) {
        this.goBinaryDownloadTemplate = goBinaryDownloadTemplate;
    }

    public void globalCacheFor(int duration, @Nonnull String timeUnit) {
        if (!timeUnit.toUpperCase().endsWith("S")) {
            timeUnit = timeUnit + "S";
        }
        this.globalCacheFor(duration, TimeUnit.valueOf(timeUnit.toUpperCase()));
    }

    public void globalCacheFor(int duration, @Nonnull TimeUnit timeUnit) {
        this.globalCacheSecond = timeUnit.toSeconds(duration);
    }

    public long getGlobalCacheSecond() {
        return this.globalCacheSecond;
    }

    public void ignorePackage(String ... pkg) {
        this.ignoredPackages.addAll(Arrays.asList(pkg));
    }

    public Set<String> getIgnoredPackages() {
        return this.ignoredPackages;
    }

    public void setIgnoredPackages(Collection<String> ignoredPackages) {
        this.userHasCustomizedIgnoredPackages = true;
        this.ignoredPackages = new HashSet<String>(ignoredPackages);
    }

    boolean isUserHasCustomizedIgnoredPackages() {
        return this.userHasCustomizedIgnoredPackages;
    }

    public void verify() {
        this.verifyPackagePath();
    }

    private void verifyPackagePath() {
        Assert.isTrue(StringUtils.isNotBlank(this.packagePath), "Package's import path must be specified!");
    }
}

