/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.vcs.mercurial;

import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.util.DateUtils;
import com.github.blindpirate.gogradle.util.ProcessUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import com.github.blindpirate.gogradle.vcs.GitMercurialAccessor;
import com.github.blindpirate.gogradle.vcs.GitMercurialCommit;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class HgClientAccessor
extends GitMercurialAccessor {
    private static final String DEFAULT_BRANCH = "default";
    private static final Pattern DEFAULT_URL_PATTERN = Pattern.compile("default\\s*=\\s*(\\S+)");
    private static final Pattern TAGS_PATTERN = Pattern.compile("(\\w+)\\s+(\\d)+:([a-fA-F0-9]+)");
    private Boolean hgClientExists;

    @Inject
    public HgClientAccessor(ProcessUtils processUtils) {
        super(processUtils);
    }

    @Override
    protected void ensureClientExists() {
        if (this.hgClientExists == null) {
            try {
                this.processUtils.runAndGetStdout("hg", "version");
                this.hgClientExists = true;
            }
            catch (Exception e) {
                this.hgClientExists = false;
            }
        }
        Assert.isTrue(this.hgClientExists, "Mercurial not found, does it exist in $PATH?");
    }

    @Override
    public void checkout(File repoRoot, String version) {
        this.run(repoRoot, Arrays.asList("hg", "checkout", version, "--clean"));
    }

    @Override
    public String getDefaultBranch(File repoRoot) {
        return DEFAULT_BRANCH;
    }

    @Override
    public String getRemoteUrl(File repoRoot) {
        return this.run(repoRoot, Arrays.asList("hg", "path"), result -> {
            Matcher matcher = DEFAULT_URL_PATTERN.matcher(result.getStdout());
            Assert.isTrue(matcher.find(), "Cannot found url in hg paths output: " + result.getStdout());
            return matcher.group(1);
        });
    }

    @Override
    public long lastCommitTimeOfPath(File repoRoot, Path relativePath) {
        return this.run(repoRoot, Arrays.asList("hg", "log", StringUtils.toUnixString(relativePath), "--limit", "1", "--template", "{date|hgdate}"), result -> DateUtils.parseRaw(result.getStdout()));
    }

    @Override
    public Optional<GitMercurialCommit> findCommitByTagOrBranch(File repository, String tag) {
        return this.findCommitByTagOrCommit(repository, tag);
    }

    private Optional<GitMercurialCommit> findCommitByTagOrCommit(File repoRoot, String tagOrCommit) {
        return this.run(repoRoot, Arrays.asList("hg", "log", "-r", tagOrCommit, "--limit", "1", "--template", "{node}:{tags}:{date|hgdate}"), result -> Optional.of(this.extractOne(result.getStdout())), result -> Optional.empty());
    }

    private GitMercurialCommit extractOne(String line) {
        String[] commitTagAndTime = line.split(":");
        Assert.isTrue(commitTagAndTime.length == 3, "Unrecognized line: " + line);
        String id = commitTagAndTime[0];
        String tag = StringUtils.trimToNull(commitTagAndTime[1]);
        long time = DateUtils.parseRaw(commitTagAndTime[2]);
        return GitMercurialCommit.of(id, tag, time);
    }

    @Override
    public List<GitMercurialCommit> getAllTags(File repository) {
        return this.run(repository, Arrays.asList("hg", "log", "--rev=tag()", "--template", "{node}:{tags}:{date|hgdate}\\n"), result -> Stream.of(result.getStdout().split("\\n")).map(this::extractOne).collect(Collectors.toList()));
    }

    @Override
    public Optional<GitMercurialCommit> findCommit(File repository, String commit) {
        return this.findCommitByTagOrCommit(repository, commit);
    }

    @Override
    public GitMercurialCommit headCommitOfBranch(File repository, String branch) {
        return this.run(repository, Arrays.asList("hg", "log", "--limit", "1", "--template", "{node}:{tags}:{date|hgdate}"), result -> this.extractOne(result.getStdout()));
    }

    @Override
    public void update(File repoRoot) {
        this.run(repoRoot, Arrays.asList("hg", "pull", "-u"));
    }

    @Override
    public void clone(String url, File directory) {
        this.run(new File("."), Arrays.asList("hg", "clone", url, directory.getAbsolutePath()));
    }
}

