/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.vcs.git;

import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.util.DateUtils;
import com.github.blindpirate.gogradle.util.IOUtils;
import com.github.blindpirate.gogradle.util.ProcessUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import com.github.blindpirate.gogradle.vcs.GitMercurialAccessor;
import com.github.blindpirate.gogradle.vcs.GitMercurialCommit;
import com.github.blindpirate.gogradle.vcs.git.GitClientLineConsumer;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class GitClientAccessor
extends GitMercurialAccessor {
    private static final String MASTER_BRANCH = "master";
    private Boolean gitClientExists;
    private static final Pattern FETCH_HEAD_MASTER_PATTERN = Pattern.compile("([0-9a-f]+)[\\s\\w-]+branch 'master' of");

    @Inject
    public GitClientAccessor(ProcessUtils processUtils) {
        super(processUtils);
    }

    @Override
    protected void ensureClientExists() {
        if (this.gitClientExists == null) {
            try {
                this.processUtils.runAndGetStdout("git", "version");
                this.gitClientExists = true;
            }
            catch (Exception e) {
                this.gitClientExists = false;
            }
        }
        Assert.isTrue(this.gitClientExists, "Git not found, does it exist in $PATH?");
    }

    @Override
    public void checkout(File repoRoot, String version) {
        this.run(repoRoot, Arrays.asList("git", "checkout", "-f", version));
    }

    @Override
    public String getDefaultBranch(File repoRoot) {
        File refsHeads = new File(repoRoot, ".git/refs/heads");
        if (new File(refsHeads, MASTER_BRANCH).exists()) {
            return MASTER_BRANCH;
        }
        List files = IOUtils.safeListFiles(refsHeads).stream().filter(File::isFile).collect(Collectors.toList());
        Assert.isNotEmpty(files, "Cannot found any files in " + StringUtils.toUnixString(refsHeads));
        files.sort(Comparator.comparing(File::lastModified).reversed());
        return ((File)files.get(0)).getName();
    }

    @Override
    public String getRemoteUrl(File repoRoot) {
        return this.run(repoRoot, Arrays.asList("git", "config", "--get", "remote.origin.url"), result -> result.getStdout().trim());
    }

    @Override
    public long lastCommitTimeOfPath(File repoRoot, Path relativePath) {
        return this.run(repoRoot, Arrays.asList("git", "log", "-1", "--pretty=format:%ct", StringUtils.toUnixString(relativePath)), result -> DateUtils.toMilliseconds(Long.parseLong(result.getStdout().trim())));
    }

    @Override
    public Optional<GitMercurialCommit> findCommitByTagOrBranch(File repository, String tag) {
        return this.findCommitTagOrBranch(repository, tag);
    }

    private Optional<GitMercurialCommit> findCommitTagOrBranch(File repoRoot, String commitTagOrBranch) {
        return this.run(repoRoot, Arrays.asList("git", "log", commitTagOrBranch, "-1", "--pretty=format:%H:%ct"), result -> {
            String[] commitAndTime = result.getStdout().split(":");
            String commit = commitAndTime[0];
            Long unixSecond = Long.valueOf(commitAndTime[1]);
            return Optional.of(GitMercurialCommit.of(commit, DateUtils.toMilliseconds(unixSecond)));
        }, result -> Optional.empty());
    }

    @Override
    public List<GitMercurialCommit> getAllTags(File repository) {
        return this.run(repository, Arrays.asList("git", "for-each-ref", "--sort=-creatordate", "--format", "%(objectname):%(refname:short):%(creatordate:raw)", "refs/tags"), this::convertToCommits);
    }

    private List<GitMercurialCommit> convertToCommits(ProcessUtils.ProcessResult result) {
        return Stream.of(result.getStdout().split("\\n")).filter(StringUtils::isNotBlank).map(line -> {
            String[] commitTagAndTime = line.split(":");
            String commit = commitTagAndTime[0];
            String tag = commitTagAndTime[1];
            long ms = DateUtils.parseRaw(commitTagAndTime[2]);
            return GitMercurialCommit.of(commit, tag, ms);
        }).collect(Collectors.toList());
    }

    @Override
    public Optional<GitMercurialCommit> findCommit(File repository, String commit) {
        return this.findCommitTagOrBranch(repository, commit);
    }

    @Override
    public GitMercurialCommit headCommitOfBranch(File repository, String branch) {
        return this.run(repository, Arrays.asList("git", "log", this.determineHeadRevision(repository, branch), "-1", "--pretty=format:%H:%ct"), result -> {
            String[] commitAndTime = result.getStdout().split(":");
            String commit = commitAndTime[0];
            Long unixSecond = Long.valueOf(commitAndTime[1]);
            return GitMercurialCommit.of(commit, DateUtils.toMilliseconds(unixSecond));
        });
    }

    private String determineHeadRevision(File repository, String branch) {
        List<String> lines;
        Optional<String> remoteBranchHeadCommit;
        File fetchHead = new File(repository, ".git/FETCH_HEAD");
        if (fetchHead.exists() && (remoteBranchHeadCommit = this.findRemoteBranchHeadCommit(lines = IOUtils.readLines(fetchHead), branch)).isPresent()) {
            return remoteBranchHeadCommit.get();
        }
        return branch;
    }

    private Optional<String> findRemoteBranchHeadCommit(List<String> lines, String branch) {
        Pattern pattern = MASTER_BRANCH.equals(branch) ? FETCH_HEAD_MASTER_PATTERN : Pattern.compile("([0-9a-f]+)[\\s\\w-]+branch '" + branch + "' of");
        for (String line : lines) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            return Optional.of(matcher.group(1));
        }
        return Optional.empty();
    }

    @Override
    public void update(File repoRoot) {
        this.runWithProgress(repoRoot, Arrays.asList("git", "fetch", "--all", "--progress"), GitClientLineConsumer.NO_OP, GitClientLineConsumer.of("Updating in " + repoRoot.getAbsolutePath()));
        this.run(repoRoot, Arrays.asList("git", "submodule", "update", "--init", "--recursive"));
    }

    @Override
    public void clone(String url, File directory) {
        this.runWithProgress(Arrays.asList("git", "clone", "--recursive", "--progress", url, directory.getAbsolutePath()), GitClientLineConsumer.NO_OP, GitClientLineConsumer.of("Cloning " + url + " to " + directory.getAbsolutePath()));
    }
}

