/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.util.http;

import com.github.blindpirate.gogradle.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;

public class HttpResponse {
    private String url;
    private int responseCode;
    private InputStream responseStream;

    private HttpResponse(String url, int responseCode, InputStream responseStream) {
        this.url = url;
        this.responseCode = responseCode;
        this.responseStream = responseStream;
    }

    public static HttpResponse of(String url, int responseCode, InputStream inputStream) {
        return new HttpResponse(url, responseCode, inputStream);
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public InputStream getResponseStream() {
        return this.responseStream;
    }

    public void checkValidity() throws IOException {
        if (this.responseCode < 200 || this.responseCode > 300) {
            throw new IOException("Error in accessing " + this.url + ", http response code: " + this.responseCode);
        }
    }

    public String readHtml() throws IOException {
        try (InputStream is = this.responseStream;){
            String string = IOUtils.toString(is);
            return string;
        }
    }
}

