/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.util;

import com.github.blindpirate.gogradle.util.ExceptionHandler;
import com.github.blindpirate.gogradle.util.IOUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Singleton;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

@Singleton
public class ProcessUtils {
    private static final Logger LOGGER = Logging.getLogger(ProcessUtils.class);

    public String getStdout(Process process) {
        String ret = this.getResult(process).getStdout();
        LOGGER.debug("Process stdout: {}", (Object)ret);
        return ret;
    }

    public String runAndGetStdout(String ... args) {
        return this.getStdout(this.run(args));
    }

    public String runAndGetStderr(String ... args) {
        return this.getResult(this.run(args)).stderr;
    }

    public String runAndGetStdout(File workingDir, String ... args) {
        return this.getStdout(this.run(Arrays.asList(args), null, workingDir));
    }

    public Process run(String ... args) {
        return this.run(Arrays.asList(args));
    }

    public Process run(List<String> args) {
        return this.run(args, null, null);
    }

    public ProcessResult getResult(Process process) {
        try {
            return ProcessResult.waitForFinish(process);
        }
        catch (InterruptedException | ExecutionException e) {
            throw ExceptionHandler.uncheckException(e);
        }
    }

    public Process run(List<String> args, Map<String, String> envs, File workingDirectory) {
        LOGGER.debug("Forking process: args {}, envs {}, workingDir {}", new Object[]{args, envs, workingDirectory});
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]).command(args);
            if (envs != null) {
                pb.environment().putAll(envs);
            }
            if (workingDirectory != null) {
                pb.directory(workingDirectory);
            }
            return pb.start();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ProcessResult runProcessWithCurrentClasspath(Class mainClass, List<String> args, Map<String, String> envs) {
        String currentClasspath = System.getProperty("java.class.path");
        ArrayList cmds = Lists.newArrayList((Object[])new String[]{"java", "-cp", currentClasspath, mainClass.getName()});
        cmds.addAll(args);
        return this.getResult(this.run(cmds, envs, null));
    }

    public static class ProcessResult {
        private static ExecutorService threadPool = Executors.newCachedThreadPool();
        private int code;
        private String stdout;
        private String stderr;

        public int getCode() {
            return this.code;
        }

        public String getStdout() {
            return this.stdout;
        }

        public String getStderr() {
            return this.stderr;
        }

        private ProcessResult(int code, String stdout, String stderr) {
            this.code = code;
            this.stdout = stdout;
            this.stderr = stderr;
        }

        private static ProcessResult waitForFinish(Process process) throws InterruptedException, ExecutionException {
            Future<Integer> code = threadPool.submit(process::waitFor);
            Future<String> stdout = threadPool.submit(() -> IOUtils.toString(process.getInputStream()));
            Future<String> stderr = threadPool.submit(() -> IOUtils.toString(process.getErrorStream()));
            return new ProcessResult(code.get(), stdout.get(), stderr.get());
        }
    }
}

