/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.util;

import com.github.blindpirate.gogradle.core.dependency.install.DependencyInstallFileFilter;
import com.github.blindpirate.gogradle.crossplatform.Os;
import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.util.ExceptionHandler;
import com.github.blindpirate.gogradle.util.StringUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public final class IOUtils {
    public static void forceMkdir(File directory) {
        try {
            FileUtils.forceMkdir((File)directory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static File mkdir(File baseDir, String newDirName) {
        Assert.isNotNull(baseDir);
        File ret = new File(baseDir, newDirName);
        IOUtils.forceMkdir(ret);
        return ret;
    }

    public static void forceDelete(File file) {
        try {
            if (file != null) {
                FileUtils.forceDelete((File)file);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void deleteQuitely(File file) {
        FileUtils.deleteQuietly((File)file);
    }

    public static boolean dirIsEmpty(File directory) {
        if (!directory.exists()) {
            return true;
        }
        String[] files = Assert.isNotNull(directory.list());
        return files.length == 0;
    }

    public static Path ensureDirExistAndWritable(Path path) {
        Assert.isTrue(path.isAbsolute(), "path must be absolute!");
        File dir = path.toFile();
        IOUtils.forceMkdir(dir);
        Assert.isTrue(Files.isWritable(dir.toPath()), "Cannot write to directory:" + path);
        return path;
    }

    public static Path ensureDirExistAndWritable(Path base, String relativePath) {
        return IOUtils.ensureDirExistAndWritable(base.resolve(Paths.get(relativePath, new String[0])));
    }

    public static void copyDirectory(File src, File dest) {
        try {
            FileUtils.copyDirectory((File)src, (File)dest);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static byte[] toByteArray(ByteBuffer buf) {
        ((Buffer)buf).position(0);
        byte[] ret = new byte[buf.remaining()];
        buf.get(ret);
        return ret;
    }

    public static void copyDependencies(File srcDir, File destDir, Set<String> subpackages) {
        try {
            Assert.isTrue(IOUtils.dirIsEmpty(destDir));
            DependencyInstallFileFilter filter = DependencyInstallFileFilter.subpackagesFilter(srcDir, subpackages);
            FileUtils.copyDirectory((File)srcDir, (File)destDir, (FileFilter)filter);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void copyFile(File src, File dest) {
        try {
            FileUtils.copyFile((File)src, (File)dest);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void touch(File file) {
        try {
            FileUtils.touch((File)file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void write(File file, CharSequence data) {
        try {
            FileUtils.write((File)file, (CharSequence)data, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static File write(File baseDir, String fileName, CharSequence data) {
        Assert.isNotNull(baseDir);
        File targetFile = new File(baseDir, fileName);
        IOUtils.forceMkdir(targetFile.getParentFile());
        IOUtils.write(targetFile, data);
        return targetFile;
    }

    public static String toString(File file) {
        String string;
        FileInputStream is = new FileInputStream(file);
        try {
            string = org.apache.commons.io.IOUtils.toString((InputStream)is, (String)"UTF-8");
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        ((InputStream)is).close();
        return string;
    }

    public static List<String> collectFileNames(List<File> files) {
        return files.stream().map(StringUtils::toUnixString).collect(Collectors.toList());
    }

    public static List<String> safeList(File dir) {
        String[] files = dir.list();
        return files == null ? Collections.emptyList() : Arrays.asList(files);
    }

    public static List<File> safeListFiles(File dir) {
        File[] files = dir.listFiles();
        return files == null ? Collections.emptyList() : Arrays.asList(files);
    }

    public static boolean isValidDirectory(File dir) {
        return dir.isDirectory();
    }

    public static String toString(InputStream inputStream) {
        try {
            return org.apache.commons.io.IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void append(File baseDir, String file, String str) {
        IOUtils.append(new File(baseDir, file), str);
    }

    public static void append(File file, String str) {
        try {
            FileUtils.write((File)file, (CharSequence)str, (String)"UTF-8", (boolean)true);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static List<String> readLines(File file) {
        String content = IOUtils.toString(file);
        if (StringUtils.isEmpty(content)) {
            return Collections.emptyList();
        }
        return Arrays.asList(content.split("\n"));
    }

    public static void walkFileTreeSafely(Path path, FileVisitor<? super Path> visitor) {
        try {
            Files.walkFileTree(path, EnumSet.noneOf(FileVisitOption.class), 100, visitor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Collection<File> filterFilesRecursively(File dir, IOFileFilter filter) {
        return FileUtils.listFiles((File)dir, (IOFileFilter)filter, (IOFileFilter)filter);
    }

    public static Collection<File> filterFilesRecursively(File dir, IOFileFilter fileFilter, IOFileFilter dirFilter) {
        return FileUtils.listFiles((File)dir, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
    }

    public static Collection<File> listAllDescendents(File dir) {
        return FileUtils.listFilesAndDirs((File)dir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
    }

    public static void clearDirectory(File dir) {
        try {
            if (dir == null || !dir.exists()) {
                return;
            }
            FileUtils.cleanDirectory((File)dir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void chmodAddX(Path filePath) {
        try {
            if (Os.getHostOs() != Os.WINDOWS) {
                Files.setPosixFilePermissions(filePath, PosixFilePermissions.fromString("rwx------"));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Path toRealPath(Path path) {
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String byteCountToDisplaySize(long size) {
        return FileUtils.byteCountToDisplaySize((long)size);
    }

    public static String encodeInternally(String s) {
        try {
            return URLEncoder.encode(s, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String decodeInternally(String encoded) {
        try {
            return URLDecoder.decode(encoded, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(e);
        }
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public static long countLines(Path path) {
        long l;
        block8: {
            Stream<String> lines = Files.lines(path);
            try {
                l = lines.count();
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            lines.close();
        }
        return l;
    }

    public static void copyURLToFile(URL url, File dest) {
        try {
            FileUtils.copyURLToFile((URL)url, (File)dest);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void serialize(Object obj, File file) {
        if (!file.exists()) {
            IOUtils.write(file, "");
        }
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));){
            oos.writeObject(obj);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Object deserialize(File file) {
        Object object;
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));
        try {
            object = ois.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                throw ExceptionHandler.uncheckException(e);
            }
        }
        ois.close();
        return object;
    }

    public static void markAndDeleteUnmarked(File rootDir, Predicate<File> predicate) {
        MarkDirectoryVisitor markVisitor = new MarkDirectoryVisitor(rootDir, predicate);
        IOUtils.walkFileTreeSafely(rootDir.toPath(), markVisitor);
        DeleteUnmarkedDirectoryVisitor deleteVisitor = new DeleteUnmarkedDirectoryVisitor(markVisitor);
        IOUtils.walkFileTreeSafely(rootDir.toPath(), deleteVisitor);
    }

    static class DeleteUnmarkedDirectoryVisitor
    extends SimpleFileVisitor<Path> {
        private MarkDirectoryVisitor markDirectoryVisitor;

        DeleteUnmarkedDirectoryVisitor(MarkDirectoryVisitor markDirectoryVisitor) {
            this.markDirectoryVisitor = markDirectoryVisitor;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes attrs) throws IOException {
            File dir = dirPath.toFile();
            if (this.isMarked(dir)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            if (this.isAncestorOfMarked(dir)) {
                return FileVisitResult.CONTINUE;
            }
            IOUtils.forceDelete(dir);
            return FileVisitResult.SKIP_SUBTREE;
        }

        private boolean isMarked(File dir) {
            return this.markDirectoryVisitor.getMarkedDirectories().contains(dir);
        }

        private boolean isAncestorOfMarked(File dir) {
            return this.markDirectoryVisitor.getAncestorsOfMarkedDirectories().contains(dir);
        }
    }

    static class MarkDirectoryVisitor
    extends SimpleFileVisitor<Path> {
        private Set<File> markedDirectories = new HashSet<File>();
        private Set<File> ancestorsOfMarkedDirectories = new HashSet<File>();
        private Predicate<File> dirPredicate;
        private File rootDir;

        MarkDirectoryVisitor(File rootDir, Predicate<File> dirPredicate) {
            this.dirPredicate = dirPredicate;
            this.rootDir = rootDir;
        }

        Set<File> getMarkedDirectories() {
            return this.markedDirectories;
        }

        Set<File> getAncestorsOfMarkedDirectories() {
            return this.ancestorsOfMarkedDirectories;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes attrs) throws IOException {
            File dir = dirPath.toFile();
            if (this.dirPredicate.test(dir)) {
                this.markedDirectories.add(dir);
                while (!this.rootDir.equals(dir)) {
                    dir = dir.getParentFile();
                    this.ancestorsOfMarkedDirectories.add(dir);
                }
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

