/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.task.go.test;

import com.github.blindpirate.gogradle.task.go.test.JsonGoTestResultExtractor;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import org.gradle.api.tasks.testing.TestResult;

class GoTestEvent {
    private static final Map<String, TestResult.ResultType> RESULT_TYPES = ImmutableMap.of((Object)"pass", (Object)TestResult.ResultType.SUCCESS, (Object)"fail", (Object)TestResult.ResultType.FAILURE, (Object)"skip", (Object)TestResult.ResultType.SKIPPED);
    private String testName;
    private String output;
    private TestResult.ResultType resultType;
    private Long durationMillis;

    GoTestEvent(String testName, String output, String action, Double elapsed) {
        this.output = output;
        this.durationMillis = this.secondToMillis(elapsed);
        this.resultType = RESULT_TYPES.get(action == null ? null : action.toLowerCase());
        this.testName = testName;
        if (this.hasTestNameResultInOutput()) {
            this.initResultNameAndTypeFromOutput();
        }
    }

    private Long secondToMillis(Double second) {
        return second == null ? null : Long.valueOf((long)(second * 1000.0));
    }

    private void initResultNameAndTypeFromOutput() {
        Matcher matcher = JsonGoTestResultExtractor.TEST_NAME_IN_OUTPUT_PATTERN.matcher(this.output);
        if (!matcher.find()) {
            throw new IllegalStateException("Can't find test name from output: " + this.output);
        }
        this.resultType = RESULT_TYPES.get(matcher.group(1).toLowerCase());
        this.testName = matcher.group(2);
        String duration = matcher.group(3);
        this.durationMillis = this.secondToMillis(duration == null ? null : Double.valueOf(Double.parseDouble(duration)));
    }

    private boolean hasTestNameResultInOutput() {
        return Stream.of("=== RUN", "--- FAIL", "--- PASS", "--- PASS").anyMatch(s -> this.output != null && this.output.contains((CharSequence)s));
    }

    String getTestName() {
        return this.testName;
    }

    TestResult.ResultType getResultType() {
        return this.resultType;
    }

    String getOutput() {
        return this.output;
    }

    Long getDurationMillis() {
        return this.durationMillis;
    }

    boolean hasTestName() {
        return this.testName != null;
    }
}

