/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.task.go.test;

import com.github.blindpirate.gogradle.crossplatform.GoBinaryManager;
import com.github.blindpirate.gogradle.task.go.PackageTestResult;
import com.github.blindpirate.gogradle.task.go.test.GoTestResultExtractor;
import com.github.blindpirate.gogradle.task.go.test.JsonGoTestResultExtractor;
import com.github.blindpirate.gogradle.task.go.test.PlainGoTestResultExtractor;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;

@Singleton
public class DefaultGoTestResultExtractor
implements GoTestResultExtractor {
    private PlainGoTestResultExtractor plainGoTestResultExtractor;
    private JsonGoTestResultExtractor jsonGoTestResultExtractor;
    private GoBinaryManager goBinaryManager;

    @Inject
    public DefaultGoTestResultExtractor(PlainGoTestResultExtractor plainExtractor, JsonGoTestResultExtractor jsonExtractor, GoBinaryManager binaryManager) {
        this.plainGoTestResultExtractor = plainExtractor;
        this.jsonGoTestResultExtractor = jsonExtractor;
        this.goBinaryManager = binaryManager;
    }

    @Override
    public List<TestClassResult> extractTestResult(PackageTestResult result) {
        if (this.goBinaryManager.supportTestJsonOutput()) {
            return this.jsonGoTestResultExtractor.extractTestResult(result);
        }
        return this.plainGoTestResultExtractor.extractTestResult(result);
    }
}

