/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.task.go;

import com.github.blindpirate.gogradle.GolangPluginSetting;
import com.github.blindpirate.gogradle.build.BuildManager;
import com.github.blindpirate.gogradle.task.AbstractGolangTask;
import com.github.blindpirate.gogradle.util.IOUtils;
import com.github.blindpirate.gogradle.util.NumberUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class GoCover
extends AbstractGolangTask {
    public static final String COVERAGE_PROFILES_PATH = ".gogradle/reports/coverage/profiles";
    private static final String COVERAGE_HTMLS_PATH = ".gogradle/reports/coverage";
    private static final String COVERAGE_HTML_STATIC_PATH = ".gogradle/reports/coverage/static";
    private static final String COVERAGE_STATIC_RESOURCE = "/coverage/static/";
    private static final Logger LOGGER = Logging.getLogger(GoCover.class);
    @Inject
    private GolangPluginSetting setting;
    @Inject
    private BuildManager buildManager;

    public GoCover() {
        this.setDescription("Run coverage task and generate coverage report.");
        this.dependsOn(new Object[]{"goTest"});
    }

    @TaskAction
    public void coverage() {
        this.setGogradleGlobalContext();
        List<File> coverageFiles = IOUtils.safeListFiles(new File(this.getProjectDir(), COVERAGE_PROFILES_PATH));
        coverageFiles.forEach(this::analyzeProfile);
        this.writeIndexHtml();
        this.updateCoverageHtmls();
        this.copyStaticResources();
    }

    @InputDirectory
    @SkipWhenEmpty
    public File getInputCoverageDirectory() {
        return new File(this.getProjectDir(), COVERAGE_PROFILES_PATH);
    }

    @OutputDirectory
    public File getCoverageDirectory() {
        return new File(this.getProjectDir(), COVERAGE_HTMLS_PATH);
    }

    private List<File> getOutputHtmls() {
        return IOUtils.safeListFiles(new File(this.getProjectDir(), COVERAGE_HTMLS_PATH)).stream().filter(file -> file.isFile() && file.getName().endsWith(".html")).collect(Collectors.toList());
    }

    private void copyStaticResources() {
        IOUtils.mkdir(this.getProjectDir(), COVERAGE_HTML_STATIC_PATH);
        List<String> files = Arrays.asList("bundle.gif", "down.gif", "greenbar.gif", "group.gif", "package.gif", "redbar.gif", "report.gif", "sort.gif", "source.gif", "up.gif");
        files.forEach(fileName -> {
            URL url = ((Object)((Object)this)).getClass().getResource(COVERAGE_STATIC_RESOURCE + fileName);
            File file = new File(this.getProjectDir(), ".gogradle/reports/coverage/static/" + fileName);
            IOUtils.copyURLToFile(url, file);
        });
    }

    private void updateCoverageHtmls() {
        this.getOutputHtmls().forEach(file -> {
            String html = IOUtils.toString(file);
            html = html.replace("<select id=\"files\">", "<a href=\"index.html\" style=\"color:white;\">" + this.getProject().getName() + "</a><span style=\"color: white;\"> &gt; </span><select id=\"files\">");
            IOUtils.write(file, html);
        });
    }

    private void writeIndexHtml() {
        List<PackageCoverage> packageCoverages = IOUtils.safeListFiles(new File(this.getProjectDir(), COVERAGE_PROFILES_PATH)).stream().map(this::extractCoverageInfo).filter(PackageCoverage::isNotEmpty).collect(Collectors.toList());
        long totalMissedLines = this.calculateTotalMissedLines(packageCoverages);
        long totalLines = this.calculateLines(packageCoverages);
        long coveredLines = totalLines - totalMissedLines;
        int totalCoverageRate = NumberUtils.percentage(coveredLines, totalLines);
        LOGGER.info("Total coverage: {}", (Object)NumberUtils.formatPercentage(coveredLines, totalLines));
        this.sortByName(packageCoverages);
        this.sortByCoverageRate(packageCoverages);
        this.setMaxPackageLines(packageCoverages);
        ImmutableMap context = ImmutableMap.builder().put((Object)"packages", packageCoverages).put((Object)"projectName", (Object)this.getProject().getName()).put((Object)"gogradleVersion", (Object)"0.11.4").put((Object)"totalMissedLines", (Object)totalMissedLines).put((Object)"totalCoverageRate", (Object)totalCoverageRate).put((Object)"totalLines", (Object)totalLines).build();
        String template = IOUtils.toString(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("coverage/templates/index.html.template"));
        String html = StringUtils.render(template, (Map<String, Object>)context);
        IOUtils.write(this.getProjectDir(), ".gogradle/reports/coverage/index.html", html);
    }

    private long calculateMaxPackageLines(List<PackageCoverage> packageCoverages) {
        Optional<Long> ret = packageCoverages.stream().map(PackageCoverage::getTotalLineCount).max(Long::compare);
        return ret.orElse(0L);
    }

    private long calculateLines(List<PackageCoverage> packageCoverages) {
        return packageCoverages.stream().mapToLong(PackageCoverage::getTotalLineCount).sum();
    }

    private long calculateTotalMissedLines(List<PackageCoverage> packageCoverages) {
        return packageCoverages.stream().mapToLong(PackageCoverage::getUncoveredLineCount).sum();
    }

    private void sortByCoverageRate(List<PackageCoverage> packageCoverages) {
        packageCoverages.sort(Comparator.comparing(PackageCoverage::getCoveredLineRate).reversed());
        for (int i = 0; i < packageCoverages.size(); ++i) {
            packageCoverages.get(i).coverageRateOrder = i;
        }
    }

    private void sortByName(List<PackageCoverage> packageCoverages) {
        packageCoverages.sort(Comparator.comparing(PackageCoverage::getName).reversed());
        for (int i = 0; i < packageCoverages.size(); ++i) {
            packageCoverages.get(i).nameOrder = i;
        }
    }

    private PackageCoverage extractCoverageInfo(File profileFile) {
        try {
            File htmlFile = this.profileFileToHtmlFile(profileFile);
            Document document = Jsoup.parse((File)htmlFile, (String)"UTF-8");
            Elements elements = document.select("option");
            PackageCoverage ret = elements.stream().map(this::extractFileCoverageInfo).collect(() -> new PackageCoverage(), (rec$, x$0) -> ((PackageCoverage)rec$).add(x$0), (rec$, x$0) -> ((PackageCoverage)rec$).add((PackageCoverage)x$0));
            ret.name = IOUtils.decodeInternally(this.removeOutExtension(profileFile));
            ret.url = htmlFile.getName();
            LOGGER.info("Coverage of package {}: {}", (Object)ret.name, (Object)ret.formatCoverageRate());
            return ret;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String removeOutExtension(File profileFile) {
        return profileFile.getName().substring(0, profileFile.getName().length() - 4);
    }

    private FileCoverage extractFileCoverageInfo(Element element) {
        String fileAndCoverage = element.text();
        int lastLeftParenIndex = StringUtils.lastIndexOf(fileAndCoverage, "(");
        String filePath = fileAndCoverage.substring(0, lastLeftParenIndex - 1);
        Double coverage = Double.parseDouble(StringUtils.substring(fileAndCoverage, lastLeftParenIndex + 1, -2));
        long lineCount = this.countLinesInFile(filePath);
        return new FileCoverage(coverage, lineCount);
    }

    private long countLinesInFile(String filePath) {
        Path relativePath = Paths.get(this.setting.getPackagePath(), new String[0]).relativize(Paths.get(filePath, new String[0]));
        return IOUtils.countLines(this.getProjectDir().toPath().resolve(relativePath));
    }

    private void analyzeProfile(File profile) {
        String htmlOutputFilePath = StringUtils.toUnixString(this.profileFileToHtmlFile(profile));
        String profilePath = StringUtils.toUnixString(profile);
        this.buildManager.go(Arrays.asList("tool", "cover", "-html=" + profilePath, "-o", htmlOutputFilePath), Collections.emptyMap());
    }

    private File profileFileToHtmlFile(File profile) {
        File htmlOutputDir = new File(this.getProjectDir(), COVERAGE_HTMLS_PATH);
        return new File(htmlOutputDir, this.removeOutExtension(profile) + ".html");
    }

    public void setMaxPackageLines(List<PackageCoverage> packages) {
        long maxPackageLines = this.calculateMaxPackageLines(packages);
        packages.forEach(p -> ((PackageCoverage)p).maxPackageTotalLine = maxPackageLines);
    }

    private static class FileCoverage {
        private double coverageRate;
        private long lineCount;

        private FileCoverage(double coverageRate, long lineCount) {
            this.coverageRate = coverageRate;
            this.lineCount = lineCount;
        }
    }

    private static class PackageCoverage {
        private static final int MAX_BAR_WIDTH = 120;
        private String name;
        private String url;
        private long coveredLineCount;
        private long uncoveredLineCount;
        private int nameOrder;
        private int coverageRateOrder;
        private long maxPackageTotalLine;

        private PackageCoverage() {
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public int getNameOrder() {
            return this.nameOrder;
        }

        public int getCoverageRateOrder() {
            return this.coverageRateOrder;
        }

        public long getCoveredLineCount() {
            return this.coveredLineCount;
        }

        public long getUncoveredLineCount() {
            return this.uncoveredLineCount;
        }

        public long getTotalLineCount() {
            return this.coveredLineCount + this.uncoveredLineCount;
        }

        public int getCoveredLineRate() {
            return NumberUtils.percentage(this.coveredLineCount, this.coveredLineCount + this.uncoveredLineCount);
        }

        public String formatCoverageRate() {
            return NumberUtils.formatPercentage(this.coveredLineCount, this.getTotalLineCount());
        }

        public long getCoveredLineWidth() {
            long width = 120L * this.coveredLineCount / this.maxPackageTotalLine;
            return width <= 0L ? 1L : width;
        }

        public long getUncoveredLineWidth() {
            long width = 120L * this.uncoveredLineCount / this.maxPackageTotalLine;
            return width <= 0L ? 1L : width;
        }

        private void add(FileCoverage coverage) {
            long coveredLinesInThatFile = Math.round(coverage.coverageRate * (double)coverage.lineCount / 100.0);
            this.coveredLineCount += coveredLinesInThatFile;
            this.uncoveredLineCount += coverage.lineCount - coveredLinesInThatFile;
        }

        private void add(PackageCoverage another) {
            this.coveredLineCount += another.coveredLineCount;
            this.uncoveredLineCount += another.uncoveredLineCount;
        }

        public static boolean isNotEmpty(PackageCoverage packageCoverage) {
            return packageCoverage.coveredLineCount != 0L || packageCoverage.uncoveredLineCount != 0L;
        }
    }
}

