/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.task;

import com.github.blindpirate.gogradle.GogradleGlobal;
import com.github.blindpirate.gogradle.GolangPluginSetting;
import com.github.blindpirate.gogradle.common.GoSourceCodeFilter;
import com.github.blindpirate.gogradle.core.GolangConfiguration;
import com.github.blindpirate.gogradle.core.GolangConfigurationManager;
import com.github.blindpirate.gogradle.core.cache.ProjectCacheManager;
import com.github.blindpirate.gogradle.core.dependency.GogradleRootProject;
import com.github.blindpirate.gogradle.core.dependency.GolangDependency;
import com.github.blindpirate.gogradle.core.dependency.GolangDependencySet;
import com.github.blindpirate.gogradle.core.dependency.LocalDirectoryDependency;
import com.github.blindpirate.gogradle.core.dependency.ResolveContext;
import com.github.blindpirate.gogradle.core.dependency.produce.DependencyVisitor;
import com.github.blindpirate.gogradle.core.dependency.produce.strategy.GogradleRootProduceStrategy;
import com.github.blindpirate.gogradle.core.dependency.tree.DependencyTreeFactory;
import com.github.blindpirate.gogradle.core.dependency.tree.DependencyTreeNode;
import com.github.blindpirate.gogradle.task.AbstractGolangTask;
import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.util.IOUtils;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class ResolveDependencies
extends AbstractGolangTask {
    @Inject
    private GolangPluginSetting setting;
    @Inject
    private DependencyTreeFactory dependencyTreeFactory;
    @Inject
    private GogradleRootProduceStrategy strategy;
    @Inject
    private GolangConfigurationManager configurationManager;
    @Inject
    private DependencyVisitor visitor;
    @Inject
    private ProjectCacheManager projectCacheManager;
    @Inject
    private GogradleRootProject gogradleRootProject;
    private DependencyTreeNode dependencyTree;

    public ResolveDependencies() {
        this.setGroup(null);
        this.dependsOn(new Object[]{"goPrepare"});
    }

    @Input
    public HashSet<GolangDependency> getDependencies() {
        this.setGogradleGlobalContext();
        return new HashSet<GolangDependency>(this.configurationManager.getByName(this.getConfigurationName()).getDependencies());
    }

    @InputFiles
    public File getExternalLockfiles() {
        return new File(this.getProjectDir(), "gogradle.lock");
    }

    @InputFiles
    public Collection<File> getGoSourceFiles() {
        return GoSourceCodeFilter.filterGoFiles(this.getProjectDir(), this.getConfigurationName());
    }

    @Input
    public List<String> getBuildTags() {
        return this.setting.getBuildTags();
    }

    @Input
    public String getBuildMode() {
        return this.setting.getBuildMode().toString();
    }

    @Input
    public String getRefreshDependenciesFlag() {
        this.setGogradleGlobalContext();
        if (GogradleGlobal.isRefreshDependencies()) {
            return UUID.randomUUID().toString();
        }
        return "";
    }

    @InputFiles
    public List<File> getLocalDirDependencies() {
        this.setGogradleGlobalContext();
        return this.configurationManager.getByName(this.getConfigurationName()).getDependencies().stream().filter(dependency -> dependency instanceof LocalDirectoryDependency).map(dependency -> (LocalDirectoryDependency)dependency).map(LocalDirectoryDependency::getRootDir).collect(Collectors.toList());
    }

    @OutputFile
    public File getSerializationFile() {
        return new File(this.getProjectDir(), ".gogradle/cache/" + this.getConfigurationName() + "-" + "0.10" + ".bin");
    }

    @TaskAction
    public void resolve() {
        this.setGogradleGlobalContext();
        this.projectCacheManager.loadPersistenceCache();
        try {
            this.resolveDependencies();
            this.writeDependencyTreeToSerializationFile();
        }
        finally {
            this.projectCacheManager.savePersistenceCache();
        }
    }

    private void writeDependencyTreeToSerializationFile() {
        IOUtils.serialize(this.dependencyTree, this.getSerializationFile());
    }

    private void resolveDependencies() {
        GolangConfiguration configuration = this.configurationManager.getByName(this.getConfigurationName());
        ResolveContext rootContext = ResolveContext.root(this.gogradleRootProject, configuration);
        this.gogradleRootProject.setDependencies(this.produceFirstLevelDependencies());
        this.dependencyTree = this.dependencyTreeFactory.getTree(rootContext, this.gogradleRootProject);
    }

    protected GolangDependencySet produceFirstLevelDependencies() {
        return this.strategy.produce(this.gogradleRootProject, this.getProjectDir(), this.visitor, this.getConfigurationName());
    }

    public DependencyTreeNode getDependencyTree() {
        if (this.dependencyTree == null && this.taskUpToDate()) {
            this.readFromSerializationFile();
        }
        return this.dependencyTree;
    }

    private boolean taskUpToDate() {
        return ((TaskInternal)TaskInternal.class.cast((Object)this)).getState().getOutcome() == TaskExecutionOutcome.UP_TO_DATE;
    }

    public GolangDependencySet getFlatDependencies() {
        DependencyTreeNode tree = this.getDependencyTree();
        return tree == null ? GolangDependencySet.empty() : tree.flatten();
    }

    private void readFromSerializationFile() {
        File serializationFile = this.getSerializationFile();
        Assert.isTrue(serializationFile.exists());
        this.dependencyTree = (DependencyTreeNode)IOUtils.deserialize(serializationFile);
    }

    public abstract String getConfigurationName();
}

