/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.pack;

import com.github.blindpirate.gogradle.core.GolangPackage;
import com.github.blindpirate.gogradle.core.pack.PackagePathResolver;
import com.github.blindpirate.gogradle.util.CollectionUtils;
import com.github.blindpirate.gogradle.util.FactoryUtil;
import com.github.blindpirate.gogradle.util.StringUtils;
import com.github.blindpirate.gogradle.util.logging.DebugLog;
import com.google.inject.BindingAnnotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DefaultPackagePathResolver
implements PackagePathResolver {
    private Map<String, GolangPackage> cache = new ConcurrentHashMap<String, GolangPackage>();
    private final List<PackagePathResolver> delegates;

    @Inject
    public DefaultPackagePathResolver(PackagePathResolver ... delegates) {
        this.delegates = CollectionUtils.immutableList(delegates);
    }

    @Override
    @DebugLog
    public Optional<GolangPackage> produce(String packagePath) {
        Optional<GolangPackage> resultFromCache = this.tryToFetchFromCache(packagePath);
        if (resultFromCache.isPresent()) {
            return resultFromCache;
        }
        Optional<GolangPackage> result = FactoryUtil.produce(this.delegates, packagePath);
        this.updateCache(packagePath, (GolangPackage)result.get());
        return result;
    }

    public void updateCache(String packagePath, GolangPackage golangPackage) {
        StringUtils.eachSubPathReverse(packagePath).forEach(subPath -> this.cache.put((String)subPath, golangPackage.resolve((String)subPath).get()));
    }

    private Optional<GolangPackage> tryToFetchFromCache(String packagePath) {
        return StringUtils.eachSubPathReverse(packagePath).map(this.cache::get).filter(Objects::nonNull).findFirst().flatMap(pkg -> pkg.resolve(packagePath));
    }

    @BindingAnnotation
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface OriginalPackagePathResolvers {
    }

    @BindingAnnotation
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface AllPackagePathResolvers {
    }
}

