/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.produce;

import com.github.blindpirate.gogradle.core.GolangPackage;
import com.github.blindpirate.gogradle.core.IncompleteGolangPackage;
import com.github.blindpirate.gogradle.core.ResolvableGolangPackage;
import com.github.blindpirate.gogradle.core.StandardGolangPackage;
import com.github.blindpirate.gogradle.core.UnrecognizedGolangPackage;
import com.github.blindpirate.gogradle.core.dependency.GogradleRootProject;
import com.github.blindpirate.gogradle.core.dependency.GolangDependencySet;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import com.github.blindpirate.gogradle.core.dependency.parse.NotationParser;
import com.github.blindpirate.gogradle.core.dependency.produce.GoImportExtractor;
import com.github.blindpirate.gogradle.core.pack.DefaultPackagePathResolver;
import com.github.blindpirate.gogradle.core.pack.PackagePathResolver;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.io.File;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SourceCodeDependencyFactory {
    public static final String TESTDATA_DIRECTORY = "testdata";
    private final GoImportExtractor goImportExtractor;
    private final PackagePathResolver packagePathResolver;
    private final NotationParser notationParser;
    private final GogradleRootProject gogradleRootProject;

    @Inject
    public SourceCodeDependencyFactory(@DefaultPackagePathResolver.AllPackagePathResolvers PackagePathResolver packagePathResolver, NotationParser notationParser, GoImportExtractor goImportExtractor, GogradleRootProject gogradleRootProject) {
        this.packagePathResolver = packagePathResolver;
        this.notationParser = notationParser;
        this.goImportExtractor = goImportExtractor;
        this.gogradleRootProject = gogradleRootProject;
    }

    public GolangDependencySet produce(ResolvedDependency resolvedDependency, File rootDir, String configuration) {
        Set<String> subpackages = resolvedDependency.getSubpackages();
        Set<String> importPaths = this.goImportExtractor.getImportPaths(rootDir, subpackages, configuration);
        return this.createDependencies(resolvedDependency, importPaths);
    }

    private GolangDependencySet createDependencies(ResolvedDependency resolvedDependency, Set<String> importPaths) {
        Set rootPackagePaths = importPaths.stream().filter(path -> !path.startsWith(resolvedDependency.getName()) && !path.startsWith(this.gogradleRootProject.getName())).map(this::getRootPath).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        Set dependencies = rootPackagePaths.stream().map(this.notationParser::parse).collect(Collectors.toSet());
        return new GolangDependencySet(dependencies);
    }

    private Optional<String> getRootPath(String importPath) {
        if (StringUtils.isBlank(importPath)) {
            return Optional.empty();
        }
        if (this.isRelativePath(importPath)) {
            return Optional.empty();
        }
        GolangPackage info = this.packagePathResolver.produce(importPath).get();
        if (info instanceof StandardGolangPackage) {
            return Optional.empty();
        }
        if (info instanceof UnrecognizedGolangPackage) {
            return Optional.of(importPath);
        }
        if (info instanceof IncompleteGolangPackage) {
            throw new IllegalStateException("Incomplete package " + info.getPathString() + ", something must be wrong");
        }
        String rootPath = ((ResolvableGolangPackage)ResolvableGolangPackage.class.cast(info)).getRootPathString();
        return Optional.of(rootPath);
    }

    private boolean isRelativePath(String importPath) {
        return importPath.startsWith(".");
    }
}

