/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.produce;

import com.github.blindpirate.gogradle.core.GolangPackage;
import com.github.blindpirate.gogradle.core.UnrecognizedGolangPackage;
import com.github.blindpirate.gogradle.core.VcsGolangPackage;
import com.github.blindpirate.gogradle.core.dependency.GolangDependency;
import com.github.blindpirate.gogradle.core.dependency.GolangDependencySet;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import com.github.blindpirate.gogradle.core.dependency.VendorResolvedDependency;
import com.github.blindpirate.gogradle.core.pack.PackagePathResolver;
import com.github.blindpirate.gogradle.util.IOUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class SecondPassVendorDirectoryVisitor
extends SimpleFileVisitor<Path> {
    private static final Logger LOGGER = Logging.getLogger(SecondPassVendorDirectoryVisitor.class);
    private ResolvedDependency parent;
    private PackagePathResolver resolver;
    private Path parentVendor;
    private GolangDependencySet dependencies = new GolangDependencySet();

    public GolangDependencySet getDependencies() {
        return this.dependencies;
    }

    public SecondPassVendorDirectoryVisitor(ResolvedDependency parent, Path parentVendor, PackagePathResolver resolver) {
        this.parent = parent;
        this.resolver = resolver;
        this.parentVendor = parentVendor;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path currentPath, BasicFileAttributes attrs) throws IOException {
        if (currentPath == this.parentVendor) {
            return FileVisitResult.CONTINUE;
        }
        String packagePath = StringUtils.toUnixString(this.parentVendor.relativize(currentPath));
        GolangPackage golangPackage = this.resolver.produce(packagePath).get();
        if (golangPackage instanceof UnrecognizedGolangPackage) {
            return this.visitUnrecognizedVendorPackage(packagePath, currentPath);
        }
        if (golangPackage instanceof VcsGolangPackage) {
            return this.visitRepoRoot(packagePath, currentPath);
        }
        LOGGER.debug("Cannot produce package with path {}, continue.", (Object)packagePath);
        return FileVisitResult.CONTINUE;
    }

    private FileVisitResult visitRepoRoot(String packagePath, Path currentPath) {
        LOGGER.debug("Produce recognized package {}.", (Object)packagePath);
        this.dependencies.add(this.createDependency(packagePath, currentPath));
        return FileVisitResult.SKIP_SUBTREE;
    }

    private FileVisitResult visitUnrecognizedVendorPackage(String packagePath, Path currentPath) {
        if (this.anyDotGoFileOrVendorDirExist(currentPath)) {
            LOGGER.debug("Produce unrecognized package {}.", (Object)packagePath);
            this.dependencies.add(this.createDependency(packagePath, currentPath));
            return FileVisitResult.SKIP_SUBTREE;
        }
        LOGGER.debug("Cannot recognize package {}, continue.", (Object)packagePath);
        return FileVisitResult.CONTINUE;
    }

    private boolean anyDotGoFileOrVendorDirExist(Path currentPath) {
        return IOUtils.isValidDirectory(currentPath.resolve("vendor").toFile()) || IOUtils.safeList(currentPath.toFile()).stream().anyMatch(fileName -> fileName.endsWith(".go"));
    }

    private GolangDependency createDependency(String packagePath, Path rootPath) {
        return VendorResolvedDependency.fromParent(packagePath, this.parent, rootPath.toFile());
    }
}

