/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.parse;

import com.github.blindpirate.gogradle.core.dependency.NotationDependency;
import com.github.blindpirate.gogradle.core.dependency.parse.MapNotationParser;
import com.github.blindpirate.gogradle.util.ConfigureUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

public abstract class AutoConfigureMapNotationParser<T extends NotationDependency>
implements MapNotationParser {
    @Override
    public NotationDependency parse(Map<String, Object> notationMap) {
        try {
            this.preConfigure(notationMap);
            NotationDependency ret = this.determineDependencyClass(notationMap).getConstructor(new Class[0]).newInstance(new Object[0]);
            ConfigureUtils.configureByMapQuietly(notationMap, ret);
            this.postConfigure(notationMap, ret);
            return ret;
        }
        catch (Exception e) {
            throw new IllegalStateException("Dependency class must have an accessible default constructor!", e);
        }
    }

    protected void preConfigure(Map<String, Object> notationMap) {
    }

    protected void postConfigure(Map<String, Object> notationMap, NotationDependency ret) {
    }

    protected Class<? extends NotationDependency> determineDependencyClass(Map<String, Object> notationMap) {
        Type superClass = this.getClass().getGenericSuperclass();
        return (Class)((ParameterizedType)superClass).getActualTypeArguments()[0];
    }
}

