/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency.install;

import com.github.blindpirate.gogradle.common.InSubpackagesPredicate;
import com.github.blindpirate.gogradle.util.IOUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Files;
import java.util.List;
import java.util.Set;

public class DependencyInstallFileFilter
implements FileFilter {
    private InSubpackagesPredicate inSubpackagesPredicate;

    public static DependencyInstallFileFilter subpackagesFilter(File rootDir, Set<String> subpackages) {
        InSubpackagesPredicate predicate = InSubpackagesPredicate.withRootDirAndSubpackages(rootDir, subpackages);
        return new DependencyInstallFileFilter(predicate);
    }

    private DependencyInstallFileFilter(InSubpackagesPredicate inSubpackagesPredicate) {
        this.inSubpackagesPredicate = inSubpackagesPredicate;
    }

    @Override
    public boolean accept(File pathname) {
        if (Files.isSymbolicLink(pathname.toPath())) {
            return false;
        }
        if (pathname.isDirectory()) {
            return this.acceptDirectory(pathname);
        }
        if (pathname.isFile()) {
            return this.inSubpackagesPredicate.test(pathname) && this.acceptFile(pathname);
        }
        return false;
    }

    private boolean acceptFile(File file) {
        return this.acceptFileName(file.getName());
    }

    private boolean acceptFileName(String name) {
        if (StringUtils.startsWithAny(name, "_", ".") || StringUtils.endsWithAny(name, "_test.go")) {
            return false;
        }
        return StringUtils.endsWithAny(name, ".go", ".asm", ".s", ".h", ".c", ".a", ".lib") || name.contains(".so");
    }

    private boolean acceptDirectory(File dir) {
        if (StringUtils.fileNameEqualsAny(dir, "testdata", "vendor")) {
            return false;
        }
        if (StringUtils.fileNameStartsWithDotOrUnderline(dir)) {
            return false;
        }
        List<String> files = IOUtils.safeList(dir);
        return files.stream().map(name -> new File(dir, (String)name)).anyMatch(this::accept);
    }
}

