/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.dependency;

import com.github.blindpirate.gogradle.GogradleGlobal;
import com.github.blindpirate.gogradle.core.cache.CacheScope;
import com.github.blindpirate.gogradle.core.cache.ProjectCacheManager;
import com.github.blindpirate.gogradle.core.dependency.AbstractResolvedDependency;
import com.github.blindpirate.gogradle.core.dependency.GolangDependencySet;
import com.github.blindpirate.gogradle.core.dependency.LocalDirectoryDependency;
import com.github.blindpirate.gogradle.core.dependency.ResolvedDependency;
import com.github.blindpirate.gogradle.core.dependency.install.LocalDirectoryDependencyManager;
import com.github.blindpirate.gogradle.core.dependency.produce.DependencyVisitor;
import com.github.blindpirate.gogradle.core.dependency.resolve.DependencyManager;
import com.github.blindpirate.gogradle.util.MapUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import com.github.blindpirate.gogradle.vcs.VcsAccessor;
import com.github.blindpirate.gogradle.vcs.VcsResolvedDependency;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class VendorResolvedDependency
extends AbstractResolvedDependency {
    private ResolvedDependency hostDependency;
    private String relativePathToHost;

    protected VendorResolvedDependency(String name, String version, long updateTime, ResolvedDependency hostDependency, String relativePathToHost) {
        super(name, version, updateTime);
        this.hostDependency = hostDependency;
        this.relativePathToHost = relativePathToHost;
    }

    public static VendorResolvedDependency fromParent(String name, ResolvedDependency parent, File rootDirOfThisVendor) {
        ResolvedDependency hostDependency = VendorResolvedDependency.determineHostDependency(parent);
        Path relativePathToHost = VendorResolvedDependency.calculateRootPathToHost(parent, name);
        File hostRootDir = VendorResolvedDependency.calculateHostRootDir(rootDirOfThisVendor, relativePathToHost);
        String version = hostDependency.toString() + "/" + StringUtils.toUnixString(relativePathToHost);
        long updateTime = VendorResolvedDependency.determineUpdateTime(hostDependency, hostRootDir, rootDirOfThisVendor, relativePathToHost);
        VendorResolvedDependency ret = new VendorResolvedDependency(name, version, updateTime, hostDependency, StringUtils.toUnixString(relativePathToHost));
        DependencyVisitor visitor = GogradleGlobal.getInstance(DependencyVisitor.class);
        ProjectCacheManager projectCacheManager = GogradleGlobal.getInstance(ProjectCacheManager.class);
        GolangDependencySet dependencies = projectCacheManager.produce(ret, resolvedDependency -> visitor.visitVendorDependencies((ResolvedDependency)resolvedDependency, rootDirOfThisVendor, "build"));
        ret.setDependencies(dependencies);
        return ret;
    }

    private static File calculateHostRootDir(File rootDirOfThisVendor, Path relativePathToHost) {
        File ret = rootDirOfThisVendor;
        for (int i = 0; i < relativePathToHost.getNameCount(); ++i) {
            ret = ret.getParentFile();
        }
        return ret;
    }

    private static long determineUpdateTime(ResolvedDependency hostDependency, File hostRootDir, File rootDirOfThisVendor, Path relativePathToHost) {
        if (hostDependency instanceof VcsResolvedDependency) {
            return ((VcsResolvedDependency)VcsResolvedDependency.class.cast(hostDependency)).getVcsType().getService(VcsAccessor.class).lastCommitTimeOfPath(hostRootDir, relativePathToHost);
        }
        if (hostDependency instanceof LocalDirectoryDependency) {
            return rootDirOfThisVendor.lastModified();
        }
        throw new IllegalStateException();
    }

    private static Path calculateRootPathToHost(ResolvedDependency parent, String packagePath) {
        if (parent instanceof VendorResolvedDependency) {
            VendorResolvedDependency parentVendorResolvedDependency = (VendorResolvedDependency)parent;
            return Paths.get(parentVendorResolvedDependency.relativePathToHost, new String[0]).resolve("vendor").resolve(packagePath);
        }
        return Paths.get("vendor", new String[0]).resolve(packagePath);
    }

    private static ResolvedDependency determineHostDependency(ResolvedDependency parent) {
        if (parent instanceof VendorResolvedDependency) {
            return ((VendorResolvedDependency)VendorResolvedDependency.class.cast((Object)parent)).hostDependency;
        }
        return parent;
    }

    public ResolvedDependency getHostDependency() {
        return this.hostDependency;
    }

    void setHostDependency(ResolvedDependency hostDependency) {
        this.hostDependency = hostDependency;
    }

    public String getRelativePathToHost() {
        return this.relativePathToHost;
    }

    @Override
    protected DependencyManager getInstaller() {
        if (this.hostDependency instanceof LocalDirectoryDependency) {
            return GogradleGlobal.getInstance(LocalDirectoryDependencyManager.class);
        }
        return ((AbstractResolvedDependency)AbstractResolvedDependency.class.cast(this.hostDependency)).getInstaller();
    }

    @Override
    public String formatVersion() {
        return this.getVersion();
    }

    @Override
    public Map<String, Object> toLockedNotation() {
        Map<String, Object> ret = MapUtils.asMap("name", this.getName());
        HashMap<String, Object> host = new HashMap<String, Object>(this.hostDependency.toLockedNotation());
        ret.put("vendorPath", StringUtils.toUnixString(this.relativePathToHost));
        ret.put("host", host);
        return ret;
    }

    @Override
    public CacheScope getCacheScope() {
        return this.hostDependency.getCacheScope();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        VendorResolvedDependency that = (VendorResolvedDependency)o;
        return Objects.equals(this.hostDependency, that.hostDependency) && Objects.equals(this.relativePathToHost, that.relativePathToHost);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hostDependency, this.relativePathToHost);
    }
}

