/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core.cache;

import com.github.blindpirate.gogradle.GolangPluginSetting;
import com.github.blindpirate.gogradle.core.GolangRepository;
import com.github.blindpirate.gogradle.core.VcsGolangPackage;
import com.github.blindpirate.gogradle.core.cache.GlobalCacheManager;
import com.github.blindpirate.gogradle.core.cache.GlobalCacheMetadata;
import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.util.DataExchange;
import com.github.blindpirate.gogradle.util.DateUtils;
import com.github.blindpirate.gogradle.util.IOUtils;
import com.github.blindpirate.gogradle.util.StringUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.wrapper.GradleUserHomeLookup;

@Singleton
public class DefaultGlobalCacheManager
implements GlobalCacheManager {
    public static final String REPO_CACHE_PATH = "go/repo";
    public static final String GO_BINARAY_CACHE_PATH = "go/binary";
    private static final String METADATA_FILE_NAME = "gogradle-metadata";
    private static final Logger LOGGER = Logging.getLogger(DefaultGlobalCacheManager.class);
    private static final int DEFAULT_CREATE_LOCKFILE_RETRY_COUNT = 10;
    private boolean initialized = false;
    private final GolangPluginSetting setting;
    private final ThreadLocal<Session> sessions = new ThreadLocal();
    private final ReentrantLock lock = new ReentrantLock();
    private Path gradleHome = GradleUserHomeLookup.gradleUserHome().toPath();

    @Inject
    public DefaultGlobalCacheManager(GolangPluginSetting setting) {
        this.setting = setting;
    }

    @Override
    public void ensureGlobalCacheExistAndWritable() {
        if (this.initialized) {
            return;
        }
        IOUtils.ensureDirExistAndWritable(this.gradleHome, REPO_CACHE_PATH);
        IOUtils.ensureDirExistAndWritable(this.gradleHome, GO_BINARAY_CACHE_PATH);
        this.initialized = true;
    }

    @Override
    public void startSession(VcsGolangPackage pkg) {
        Assert.isNull(this.sessions.get());
        this.ensureGlobalCacheExistAndWritable();
        try {
            this.lock.lock();
            this.sessions.set(new Session(pkg));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void endSession() {
        try {
            if (this.sessions.get() == null) {
                return;
            }
            this.sessions.get().cleanUp();
            this.sessions.set(null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void repoUpdated() {
        this.sessions.get().repositoryMetadata.updated();
    }

    @Override
    public File getGlobalCacheRepoDir() {
        return this.sessions.get().repoRoot;
    }

    private Optional<GlobalCacheMetadata.GolangRepositoryMetadata> findMatchedRepository(GlobalCacheMetadata metadata, GolangRepository repository) {
        return metadata.getRepositories().stream().filter(repository::match).findFirst();
    }

    @Override
    public File getGlobalGoBinCacheDir(String relativePath) {
        this.ensureGlobalCacheExistAndWritable();
        return this.gradleHome.resolve(GO_BINARAY_CACHE_PATH).resolve(relativePath).toFile();
    }

    private File getRepoPath(VcsGolangPackage pkg, String dirName) {
        return this.gradleHome.resolve(REPO_CACHE_PATH).resolve(pkg.getRootPath()).resolve(dirName).toFile();
    }

    private File getMetadataPath(String packagePath) {
        this.ensureGlobalCacheExistAndWritable();
        return this.gradleHome.resolve(REPO_CACHE_PATH).resolve(packagePath).resolve(METADATA_FILE_NAME).toFile();
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"})
    private File getMetadataPath(VcsGolangPackage pkg) {
        return this.getMetadataPath(pkg.getRootPathString());
    }

    private File getMetadataPath(Path path) {
        return this.getMetadataPath(StringUtils.toUnixString(path));
    }

    @Override
    public Optional<GlobalCacheMetadata> getMetadata(Path packagePath) {
        this.ensureGlobalCacheExistAndWritable();
        try {
            return this.doGetMetadata(packagePath);
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<GlobalCacheMetadata> doGetMetadata(Path packagePath) throws IOException {
        File lockFile = this.getMetadataPath(packagePath);
        FileChannel channel = null;
        FileLock fileLock = null;
        try {
            channel = new RandomAccessFile(lockFile, "r").getChannel();
            fileLock = channel.tryLock(0L, Long.MAX_VALUE, true);
            if (fileLock == null) {
                Optional<GlobalCacheMetadata> optional = Optional.empty();
                return optional;
            }
            Optional<GlobalCacheMetadata> optional = this.getMetadataFromFile(channel);
            return optional;
        }
        catch (FileNotFoundException | OverlappingFileLockException e) {
            Optional<GlobalCacheMetadata> optional = Optional.empty();
            return optional;
        }
        finally {
            if (fileLock != null) {
                fileLock.release();
            }
            if (channel != null) {
                channel.close();
            }
        }
    }

    @Override
    public boolean currentRepositoryIsUpToDate() {
        long cacheSecond = this.setting.getGlobalCacheSecond();
        long updateTime = this.sessions.get().repositoryMetadata.getLastUpdatedTime();
        return System.currentTimeMillis() - updateTime < DateUtils.toMilliseconds(cacheSecond);
    }

    private Optional<GlobalCacheMetadata> getMetadataFromFile(FileChannel fileChannel) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate((int)fileChannel.size());
        fileChannel.position(0L);
        fileChannel.read(buf);
        String fileContent = new String(IOUtils.toByteArray(buf), "UTF-8");
        if (StringUtils.isEmpty(fileContent)) {
            return Optional.empty();
        }
        return Optional.of(DataExchange.parseYaml(fileContent, GlobalCacheMetadata.class));
    }

    private FileChannel createLockFileIfNecessary(File lockFile) throws IOException {
        int retryCount = 10;
        while (retryCount-- > 0) {
            try {
                return new RandomAccessFile(lockFile, "rwd").getChannel();
            }
            catch (FileNotFoundException e) {
                LOGGER.debug("try to create file {} failed, retry count {}", (Object)lockFile.getAbsolutePath(), (Object)retryCount);
            }
        }
        throw new IOException("Fail to create lock file " + lockFile.getAbsolutePath());
    }

    @SuppressFBWarnings(value={"SIC_THREADLOCAL_DEADLY_EMBRACE"})
    private class Session {
        private FileChannel fileChannel;
        private GlobalCacheMetadata metadata;
        private GlobalCacheMetadata.GolangRepositoryMetadata repositoryMetadata;
        private FileLock fileLock;
        private File repoRoot;

        private Session(VcsGolangPackage pkg) throws IOException {
            File lockFile = DefaultGlobalCacheManager.this.getMetadataPath(pkg);
            IOUtils.ensureDirExistAndWritable(lockFile.getParentFile().toPath());
            this.fileChannel = DefaultGlobalCacheManager.this.createLockFileIfNecessary(lockFile);
            this.fileLock = this.fileChannel.lock();
            this.metadata = DefaultGlobalCacheManager.this.getMetadataFromFile(this.fileChannel).orElse(GlobalCacheMetadata.newMetadata(pkg));
            Optional matched = DefaultGlobalCacheManager.this.findMatchedRepository(this.metadata, pkg.getRepository());
            if (!matched.isPresent()) {
                this.metadata.addRepository(pkg.getRepository());
                matched = DefaultGlobalCacheManager.this.findMatchedRepository(this.metadata, pkg.getRepository());
            }
            this.repositoryMetadata = (GlobalCacheMetadata.GolangRepositoryMetadata)matched.get();
            this.repoRoot = DefaultGlobalCacheManager.this.getRepoPath(pkg, this.repositoryMetadata.getDir());
        }

        private Session cleanUp() throws IOException {
            this.updateMetadata();
            this.fileLock.release();
            this.fileChannel.close();
            return this;
        }

        private void updateMetadata() throws IOException {
            if (this.metadata.isDirty()) {
                byte[] bytesToWrite = DataExchange.toYaml(this.metadata).getBytes("UTF-8");
                this.fileChannel.position(0L);
                this.fileChannel.truncate(bytesToWrite.length);
                this.fileChannel.write(ByteBuffer.wrap(bytesToWrite));
            }
        }
    }
}

