/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle.core;

import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.util.StringUtils;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;

public abstract class GolangPackage
implements Serializable {
    private String pathString;

    public GolangPackage(Path path) {
        this.pathString = StringUtils.toUnixString(path);
    }

    public Path getPath() {
        return Paths.get(this.pathString, new String[0]);
    }

    public Path getRootPath() {
        return this.getPath();
    }

    public String getPathString() {
        return this.pathString;
    }

    public String getRootPathString() {
        return this.getPathString();
    }

    public Optional<GolangPackage> resolve(Path packagePath) {
        Path path = this.getPath();
        Assert.isTrue(packagePath.startsWith(path) || path.startsWith(packagePath));
        if (path.equals(packagePath)) {
            return Optional.of(this);
        }
        if (path.startsWith(packagePath)) {
            return this.shorterPath(packagePath);
        }
        return this.longerPath(packagePath);
    }

    public Optional<GolangPackage> resolve(String packagePath) {
        return this.resolve(Paths.get(packagePath, new String[0]));
    }

    protected abstract Optional<GolangPackage> longerPath(Path var1);

    protected abstract Optional<GolangPackage> shorterPath(Path var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GolangPackage that = (GolangPackage)o;
        return Objects.equals(this.pathString, that.pathString);
    }

    public int hashCode() {
        return Objects.hash(this.pathString);
    }
}

