/*
 * Decompiled with CFR 0.152.
 */
package com.github.blindpirate.gogradle;

import com.github.blindpirate.gogradle.build.BuildManager;
import com.github.blindpirate.gogradle.task.AbstractGolangTask;
import com.github.blindpirate.gogradle.util.Assert;
import com.github.blindpirate.gogradle.util.ConfigureUtils;
import com.github.blindpirate.gogradle.util.IOUtils;
import com.google.inject.Injector;
import groovy.lang.Closure;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.tools.ant.types.Commandline;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.TaskAction;

public class Go
extends AbstractGolangTask {
    protected static final Logger LOGGER = Logging.getLogger(Go.class);
    protected BuildManager buildManager;
    protected Consumer<String> stdoutLineConsumer;
    protected Consumer<String> stderrLineConsumer;
    protected Map<String, String> environment = new HashMap<String, String>();
    protected Boolean continueOnFailure;
    protected List<Integer> exitValues = new ArrayList<Integer>();
    protected List<GoAction> goActions = new ArrayList<GoAction>();

    public Go() {
        this.setDescription("Custom go task.");
        this.dependsOn(new Object[]{"goPrepare"});
        Injector injector = (Injector)this.getProject().getExtensions().getByName("GOGRADLE_INJECTOR");
        this.buildManager = (BuildManager)injector.getInstance(BuildManager.class);
    }

    @TaskAction
    public void executeTask() {
        this.setGogradleGlobalContext();
        this.exitValues = this.goActions.stream().map(Supplier::get).collect(Collectors.toList());
    }

    public void environment(Map<String, String> map) {
        this.environment.putAll(map);
    }

    public void environment(String key, String value) {
        this.environment.put(key, value);
    }

    @Deprecated
    public void setContinueWhenFail(Boolean continueWhenFail) {
        LOGGER.warn("continueWhenFail is deprecated, please use continueOnFailure instead.");
        this.continueOnFailure = continueWhenFail;
    }

    public void setContinueOnFailure(Boolean continueWhenFail) {
        this.continueOnFailure = continueWhenFail;
    }

    public List<GoAction> getGoActions() {
        return this.goActions;
    }

    public void go(String arg) {
        this.go(arg, null);
    }

    public void go(String arg, Closure configureClosure) {
        Assert.isNotBlank(arg, "Arguments must not be blank!");
        this.go(this.extractArgs(arg), configureClosure);
    }

    public void go(List<String> args) {
        this.go(args, null);
    }

    public void go(List<String> args, Closure configureClosure) {
        this.goOrRun(args, configureClosure, this.buildManager::go);
    }

    public void run(String arg) {
        this.run(this.extractArgs(arg), null);
    }

    public void run(String arg, Closure configureClosure) {
        Assert.isNotBlank(arg, "Arguments must not be blank!");
        this.run(this.extractArgs(arg), configureClosure);
    }

    public void run(List<String> args) {
        this.run(args, null);
    }

    public void run(List<String> args, Closure configureClosure) {
        this.goOrRun(args, configureClosure, this.buildManager::run);
    }

    public Consumer<String> appendTo(String file) {
        return new FileWritingConsumer(file, true);
    }

    public Consumer<String> writeTo(String file) {
        return new FileWritingConsumer(file, false);
    }

    public Consumer<String> devNull() {
        return line -> {};
    }

    public void stdout(Consumer<String> consumer) {
        this.stdoutLineConsumer = consumer;
    }

    public void stderr(Consumer<String> consumer) {
        this.stderrLineConsumer = consumer;
    }

    public void stdout(Closure closure) {
        this.stdoutLineConsumer = new ClosureLineConsumer(closure);
    }

    public void stderr(Closure closure) {
        this.stderrLineConsumer = new ClosureLineConsumer(closure);
    }

    public List<Integer> getExitValues() {
        return this.exitValues;
    }

    public Integer getExitValue() {
        if (this.exitValues.size() == 1) {
            return this.exitValues.get(0);
        }
        return this.exitValues.stream().allMatch(value -> value == 0) ? 0 : -1;
    }

    public void addGoAction(GoAction goAction) {
        this.goActions.add(new GoAction(goAction));
    }

    private void goOrRun(List<String> args, Closure configureClosure, BuildFunction function) {
        Assert.isNotEmpty(args, "Arguments must not be blank!");
        GoAction action = new GoAction(args, function);
        ConfigureUtils.configure(action, configureClosure);
        this.goActions.add(action);
    }

    private List<String> extractArgs(String arg) {
        return Arrays.asList(Commandline.translateCommandline((String)arg));
    }

    public static interface BuildFunction {
        public int apply(List<String> var1, Map<String, String> var2, Consumer<String> var3, Consumer<String> var4, boolean var5);
    }

    public static class ClosureLineConsumer
    implements Consumer<String> {
        private Closure closure;

        public ClosureLineConsumer(Closure closure) {
            this.closure = closure;
        }

        @Override
        public void accept(String s) {
            this.closure.call((Object)s);
        }
    }

    private class FileWritingConsumer
    implements Consumer<String> {
        private File file;

        private FileWritingConsumer(String file, boolean append) {
            Path filePath = Paths.get(file, new String[0]);
            this.file = filePath.isAbsolute() ? filePath.toFile() : new File(Go.this.getProjectDir(), file);
            if (!append) {
                IOUtils.write(this.file, "");
            }
        }

        @Override
        public void accept(String line) {
            IOUtils.append(this.file, line + "\n");
        }
    }

    public class GoAction
    implements Supplier<Integer> {
        private final List<String> args;
        private final BuildFunction function;
        private Consumer<String> stdoutLineConsumer;
        private Consumer<String> stderrLineConsumer;
        private Map<String, String> environment = new HashMap<String, String>();
        private Boolean continueOnFailure;

        protected GoAction() {
            this.args = null;
            this.function = null;
        }

        private GoAction(List<String> args, BuildFunction function) {
            this.args = args;
            this.function = function;
        }

        public GoAction(GoAction instance) {
            this.args = instance.args;
            this.function = instance.function;
            this.stdoutLineConsumer = instance.stdoutLineConsumer;
            this.stderrLineConsumer = instance.stderrLineConsumer;
            this.environment = new HashMap<String, String>(instance.environment);
            this.continueOnFailure = instance.continueOnFailure;
        }

        @Override
        public Integer get() {
            return this.function.apply(this.args, this.getEnvironment(), this.getStdoutLineConsumer(), this.getStderrLineConsumer(), this.isContinueOnFailure());
        }

        public void environment(Map<String, String> map) {
            this.environment.putAll(map);
        }

        public void environment(String key, String value) {
            this.environment.put(key, value);
        }

        public void stdout(Consumer<String> consumer) {
            this.stdoutLineConsumer = consumer;
        }

        public void stderr(Consumer<String> consumer) {
            this.stderrLineConsumer = consumer;
        }

        public void stdout(Closure closure) {
            this.stdoutLineConsumer = new ClosureLineConsumer(closure);
        }

        public void stderr(Closure closure) {
            this.stderrLineConsumer = new ClosureLineConsumer(closure);
        }

        public Consumer<String> appendTo(String file) {
            return Go.this.appendTo(file);
        }

        public Consumer<String> writeTo(String file) {
            return Go.this.writeTo(file);
        }

        public Consumer<String> devNull() {
            return Go.this.devNull();
        }

        public void setContinueOnFailure(Boolean continueOnFailure) {
            this.continueOnFailure = continueOnFailure;
        }

        public Consumer<String> getStdoutLineConsumer() {
            if (this.stdoutLineConsumer != null) {
                return this.stdoutLineConsumer;
            }
            if (Go.this.stdoutLineConsumer != null) {
                return Go.this.stdoutLineConsumer;
            }
            return arg_0 -> ((Logger)LOGGER).quiet(arg_0);
        }

        public Consumer<String> getStderrLineConsumer() {
            if (this.stderrLineConsumer != null) {
                return this.stderrLineConsumer;
            }
            if (Go.this.stderrLineConsumer != null) {
                return Go.this.stderrLineConsumer;
            }
            return arg_0 -> ((Logger)LOGGER).error(arg_0);
        }

        public Map<String, String> getEnvironment() {
            HashMap<String, String> outsideEnvs = new HashMap<String, String>(Go.this.environment);
            outsideEnvs.putAll(this.environment);
            return outsideEnvs;
        }

        public boolean isContinueOnFailure() {
            if (this.continueOnFailure != null) {
                return this.continueOnFailure;
            }
            if (Go.this.continueOnFailure != null) {
                return Go.this.continueOnFailure;
            }
            return false;
        }
    }
}

