/*
 * Decompiled with CFR 0.152.
 */
package com.github.bjornvester.xjc;

import com.github.bjornvester.xjc.XjcExtension;
import com.github.bjornvester.xjc.XjcTask;
import com.github.bjornvester.xjc.XjcWorker;
import com.github.bjornvester.xjc.XjcWorkerParams;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaForkOptions;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u00105\u001a\u000206H\u0007J\b\u00107\u001a\u000206H\u0002J\b\u00108\u001a\u000209H\u0002J\b\u0010:\u001a\u000206H\u0002R\u001e\u0010\u000b\u001a\u00020\f8G@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00128\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0019\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u00128G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u0019\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u001c8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u001f\u001a\u00020 8G\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0013\u0010#\u001a\u00020 8G\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\"R\u0013\u0010%\u001a\u00020 8G\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(8G\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0019\u0010,\u001a\b\u0012\u0004\u0012\u00020)0(8G\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010+R\u0019\u0010.\u001a\b\u0012\u0004\u0012\u00020)0(8G\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010+R\u0013\u00100\u001a\u00020 8G\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\"R\u001e\u00102\u001a\u00020\f8G@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010\u000e\"\u0004\b4\u0010\u0010\u00a8\u0006;"}, d2={"Lcom/github/bjornvester/xjc/XjcTask;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "projectLayout", "Lorg/gradle/api/file/ProjectLayout;", "fileSystemOperations", "Lorg/gradle/api/file/FileSystemOperations;", "(Lorg/gradle/workers/WorkerExecutor;Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/api/file/ProjectLayout;Lorg/gradle/api/file/FileSystemOperations;)V", "bindingFiles", "Lorg/gradle/api/file/FileCollection;", "getBindingFiles", "()Lorg/gradle/api/file/FileCollection;", "setBindingFiles", "(Lorg/gradle/api/file/FileCollection;)V", "defaultPackage", "Lorg/gradle/api/provider/Property;", "", "getDefaultPackage", "()Lorg/gradle/api/provider/Property;", "generateEpisode", "", "getGenerateEpisode", "markGenerated", "getMarkGenerated", "options", "Lorg/gradle/api/provider/ListProperty;", "getOptions", "()Lorg/gradle/api/provider/ListProperty;", "outputJavaDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputJavaDir", "()Lorg/gradle/api/file/DirectoryProperty;", "outputResourcesDir", "getOutputResourcesDir", "tmpBindFiles", "getTmpBindFiles", "xjcBindConfiguration", "Lorg/gradle/api/NamedDomainObjectProvider;", "Lorg/gradle/api/artifacts/Configuration;", "getXjcBindConfiguration", "()Lorg/gradle/api/NamedDomainObjectProvider;", "xjcConfiguration", "getXjcConfiguration", "xjcPluginsConfiguration", "getXjcPluginsConfiguration", "xsdDir", "getXsdDir", "xsdFiles", "getXsdFiles", "setXsdFiles", "doCodeGeneration", "", "extractBindFilesFromJars", "getXjcExtension", "Lcom/github/bjornvester/xjc/XjcExtension;", "validateOptions", "xjc-gradle-plugin"})
public class XjcTask
extends DefaultTask {
    @NotNull
    private final Property<String> defaultPackage;
    @NotNull
    private final DirectoryProperty xsdDir;
    @Optional
    @NotNull
    private FileCollection xsdFiles;
    @NotNull
    private final NamedDomainObjectProvider<Configuration> xjcConfiguration;
    @NotNull
    private final NamedDomainObjectProvider<Configuration> xjcPluginsConfiguration;
    @NotNull
    private final NamedDomainObjectProvider<Configuration> xjcBindConfiguration;
    @Optional
    @Input
    @NotNull
    private final Property<Boolean> generateEpisode;
    @Optional
    @NotNull
    private FileCollection bindingFiles;
    @NotNull
    private final ListProperty<String> options;
    @NotNull
    private final Property<Boolean> markGenerated;
    @NotNull
    private final DirectoryProperty outputJavaDir;
    @NotNull
    private final DirectoryProperty outputResourcesDir;
    @NotNull
    private final DirectoryProperty tmpBindFiles;
    private final WorkerExecutor workerExecutor;
    private final FileSystemOperations fileSystemOperations;

    @Optional
    @Input
    @NotNull
    public final Property<String> getDefaultPackage() {
        return this.defaultPackage;
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final DirectoryProperty getXsdDir() {
        return this.xsdDir;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileCollection getXsdFiles() {
        return this.xsdFiles;
    }

    public final void setXsdFiles(@NotNull FileCollection fileCollection) {
        Intrinsics.checkNotNullParameter((Object)fileCollection, (String)"<set-?>");
        this.xsdFiles = fileCollection;
    }

    @Classpath
    @NotNull
    public final NamedDomainObjectProvider<Configuration> getXjcConfiguration() {
        return this.xjcConfiguration;
    }

    @Classpath
    @NotNull
    public final NamedDomainObjectProvider<Configuration> getXjcPluginsConfiguration() {
        return this.xjcPluginsConfiguration;
    }

    @Classpath
    @NotNull
    public final NamedDomainObjectProvider<Configuration> getXjcBindConfiguration() {
        return this.xjcBindConfiguration;
    }

    @NotNull
    public final Property<Boolean> getGenerateEpisode() {
        return this.generateEpisode;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileCollection getBindingFiles() {
        return this.bindingFiles;
    }

    public final void setBindingFiles(@NotNull FileCollection fileCollection) {
        Intrinsics.checkNotNullParameter((Object)fileCollection, (String)"<set-?>");
        this.bindingFiles = fileCollection;
    }

    @Input
    @NotNull
    public final ListProperty<String> getOptions() {
        return this.options;
    }

    @Input
    @NotNull
    public final Property<Boolean> getMarkGenerated() {
        return this.markGenerated;
    }

    @OutputDirectory
    @NotNull
    public final DirectoryProperty getOutputJavaDir() {
        return this.outputJavaDir;
    }

    @OutputDirectory
    @NotNull
    public final DirectoryProperty getOutputResourcesDir() {
        return this.outputResourcesDir;
    }

    @Internal
    @NotNull
    public final DirectoryProperty getTmpBindFiles() {
        return this.tmpBindFiles;
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void doCodeGeneration() {
        void episodeFilepathArg;
        this.fileSystemOperations.delete((Action)new Action<DeleteSpec>(this){
            final /* synthetic */ XjcTask this$0;

            public final void execute(@NotNull DeleteSpec $this$delete) {
                Intrinsics.checkNotNullParameter((Object)$this$delete, (String)"$receiver");
                $this$delete.delete(new Object[]{this.this$0.getOutputJavaDir()});
            }
            {
                this.this$0 = xjcTask;
            }
        });
        this.fileSystemOperations.delete((Action)new Action<DeleteSpec>(this){
            final /* synthetic */ XjcTask this$0;

            public final void execute(@NotNull DeleteSpec $this$delete) {
                Intrinsics.checkNotNullParameter((Object)$this$delete, (String)"$receiver");
                $this$delete.delete(new Object[]{this.this$0.getOutputResourcesDir()});
            }
            {
                this.this$0 = xjcTask;
            }
        });
        this.fileSystemOperations.delete((Action)new Action<DeleteSpec>(this){
            final /* synthetic */ XjcTask this$0;

            public final void execute(@NotNull DeleteSpec $this$delete) {
                Intrinsics.checkNotNullParameter((Object)$this$delete, (String)"$receiver");
                $this$delete.delete(new Object[]{this.this$0.getTmpBindFiles()});
            }
            {
                this.this$0 = xjcTask;
            }
        });
        Object object = this.outputJavaDir.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"outputJavaDir.get()");
        ((Directory)object).getAsFile().mkdirs();
        Object object2 = this.outputResourcesDir.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"outputResourcesDir.get()");
        ((Directory)object2).getAsFile().mkdirs();
        this.validateOptions();
        this.getLogger().info("Loading XSD files " + this.xsdFiles.getFiles());
        this.getLogger().debug("XSD files are loaded from " + (Directory)this.xsdDir.get());
        Set set = ((Configuration)this.xjcConfiguration.get()).resolve();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"xjcConfiguration.get().resolve()");
        Set xjcClasspath = SetsKt.plus((Set)set, this.xjcPluginsConfiguration);
        this.getLogger().debug("Loading JAR files for XJC: " + xjcClasspath);
        this.extractBindFilesFromJars();
        FileTree fileTree = this.tmpBindFiles.getAsFileTree();
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"tmpBindFiles.asFileTree");
        Set set2 = fileTree.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"tmpBindFiles.asFileTree.files");
        Set set3 = this.bindingFiles.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"bindingFiles.files");
        Set allBindingFiles = SetsKt.plus((Set)set2, (Iterable)set3);
        Collection collection = allBindingFiles;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.getLogger().info("Loading binding files: " + allBindingFiles);
        }
        collection = new Ref.ObjectRef();
        ((Ref.ObjectRef)collection).element = "";
        Object object3 = this.generateEpisode.get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"generateEpisode.get()");
        if (((Boolean)object3).booleanValue()) {
            Provider provider = this.outputResourcesDir.dir("META-INF");
            Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"outputResourcesDir.dir(\"META-INF\")");
            Provider episodeDir = provider;
            Object object4 = episodeDir.get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"episodeDir.get()");
            ((Directory)object4).getAsFile().mkdirs();
            RegularFile regularFile = ((Directory)episodeDir.get()).file("sun-jaxb.episode");
            Intrinsics.checkNotNullExpressionValue((Object)regularFile, (String)"episodeDir.get().file(\"sun-jaxb.episode\")");
            File file = regularFile.getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"episodeDir.get().file(\"sun-jaxb.episode\").asFile");
            String string = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"episodeDir.get().file(\"s\u2026ode\").asFile.absolutePath");
            episodeFilepathArg.element = string;
            this.getLogger().info("Generating episode file in " + (String)episodeFilepathArg.element);
        }
        WorkQueue workQueue2 = this.workerExecutor.processIsolation((Action)new Action<ProcessWorkerSpec>(this, xjcClasspath){
            final /* synthetic */ XjcTask this$0;
            final /* synthetic */ Set $xjcClasspath;

            public final void execute(@NotNull ProcessWorkerSpec $this$processIsolation) {
                Intrinsics.checkNotNullParameter((Object)$this$processIsolation, (String)"$receiver");
                JavaForkOptions javaForkOptions = $this$processIsolation.getForkOptions();
                Intrinsics.checkNotNullExpressionValue((Object)javaForkOptions, (String)"forkOptions");
                javaForkOptions.setSystemProperties(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"javax.xml.parsers.DocumentBuilderFactory", (Object)"com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl"), TuplesKt.to((Object)"javax.xml.parsers.SAXParserFactory", (Object)"com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl"), TuplesKt.to((Object)"javax.xml.validation.SchemaFactory:http://www.w3.org/2001/XMLSchema", (Object)"org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory"), TuplesKt.to((Object)"javax.xml.accessExternalSchema", (Object)"all")}));
                Logger logger = this.this$0.getLogger();
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
                if (logger.isDebugEnabled()) {
                    JavaForkOptions javaForkOptions2 = $this$processIsolation.getForkOptions();
                    Intrinsics.checkNotNullExpressionValue((Object)javaForkOptions2, (String)"forkOptions");
                    Map map = javaForkOptions2.getSystemProperties();
                    Intrinsics.checkNotNullExpressionValue((Object)map, (String)"forkOptions.systemProperties");
                    map.put("com.sun.tools.xjc.Options.findServices", "");
                }
                JavaForkOptions javaForkOptions3 = $this$processIsolation.getForkOptions();
                String string = System.getenv("LANG");
                if (string == null) {
                    string = "C.UTF-8";
                }
                javaForkOptions3.environment("LANG", (Object)string);
                $this$processIsolation.getClasspath().from(new Object[]{this.$xjcClasspath});
            }
            {
                this.this$0 = xjcTask;
                this.$xjcClasspath = set;
            }
        });
        System.setProperty("com.sun.tools.xjc.Options.findServices", "true");
        workQueue2.submit(XjcWorker.class, (Action)new Action<XjcWorkerParams>(this, (Ref.ObjectRef)episodeFilepathArg, allBindingFiles){
            final /* synthetic */ XjcTask this$0;
            final /* synthetic */ Ref.ObjectRef $episodeFilepathArg;
            final /* synthetic */ Set $allBindingFiles;

            public final void execute(@NotNull XjcWorkerParams $this$submit) {
                Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$receiver");
                XjcTask task2 = this.this$0;
                Set set = task2.getXsdFiles().getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"task.xsdFiles.files");
                $this$submit.setXsdFiles(set);
                Object object = task2.getOutputJavaDir().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"task.outputJavaDir.get()");
                File file = ((Directory)object).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"task.outputJavaDir.get().asFile");
                $this$submit.setOutputJavaDir(file);
                Object object2 = task2.getOutputResourcesDir().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"task.outputResourcesDir.get()");
                File file2 = ((Directory)object2).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"task.outputResourcesDir.get().asFile");
                $this$submit.setOutputResourceDir(file2);
                $this$submit.setDefaultPackage(task2.getDefaultPackage());
                $this$submit.setEpisodeFilepath((String)this.$episodeFilepathArg.element);
                $this$submit.setBindFiles(this.$allBindingFiles);
                Logger logger = task2.getLogger();
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"task.logger");
                $this$submit.setVerbose(logger.isDebugEnabled());
                Object object3 = task2.getOptions().get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"task.options.get()");
                $this$submit.setOptions((List)object3);
                Object object4 = task2.getMarkGenerated().get();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"task.markGenerated.get()");
                $this$submit.setMarkGenerated((Boolean)object4);
            }
            {
                this.this$0 = xjcTask;
                this.$episodeFilepathArg = objectRef;
                this.$allBindingFiles = set;
            }
        });
    }

    private final void validateOptions() {
        Map prohibitedOptions = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"-classpath", (Object)"Leads to resource leaks. Use the 'xjc', 'xjcBindings' or 'xjcPlugins' configuration instead"), TuplesKt.to((Object)"-d", (Object)"Configured through the 'outputJavaDir' property"), TuplesKt.to((Object)"-b", (Object)"Configured through the 'bindingFiles' property"), TuplesKt.to((Object)"-p", (Object)"Configured through the 'defaultPackage' property"), TuplesKt.to((Object)"-episode", (Object)"Configured through the 'generateEpisode' property"), TuplesKt.to((Object)"-mark-generated", (Object)"Configured through the 'markGenerated' property")});
        Object object = this.options.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"options.get()");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String option = (String)element$iv;
            boolean bl = false;
            if (!prohibitedOptions.containsKey(option)) continue;
            throw (Throwable)new GradleException("the option '" + option + "' is not allowed in this plugin. Reason: " + (String)prohibitedOptions.get(option));
        }
    }

    private final void extractBindFilesFromJars() {
        Set set = ((Configuration)this.xjcBindConfiguration.get()).resolve();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"xjcBindConfiguration.get().resolve()");
        Set bindJarFiles = set;
        this.getLogger().debug("Loading binding JAR files: " + bindJarFiles);
        Iterable $this$forEach$iv = bindJarFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File bindJarFile = (File)element$iv;
            boolean bl = false;
            File file = bindJarFile;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"bindJarFile");
            if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"jar")) {
                Set episodeFiles2;
                FileCollection fileCollection = this.getProject().zipTree((Object)bindJarFile).filter((Spec)extractBindFilesFromJars.1.episodeFiles.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"project.zipTree(bindJarF\u2026e == \"sun-jaxb.episode\" }");
                Intrinsics.checkNotNullExpressionValue((Object)fileCollection.getFiles(), (String)"project.zipTree(bindJarF\u2026sun-jaxb.episode\" }.files");
                if (episodeFiles2.isEmpty()) {
                    this.getLogger().warn("No episodes (sun-jaxb.episode) found in bind jar file " + bindJarFile.getName());
                    continue;
                }
                Object object = CollectionsKt.first((Iterable)episodeFiles2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"episodeFiles.first()");
                File file2 = (File)object;
                StringBuilder stringBuilder = new StringBuilder();
                String string = bindJarFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bindJarFile.name");
                Object object2 = this.tmpBindFiles.file(stringBuilder.append(StringsKt.removeSuffix((String)string, (CharSequence)".jar")).append(".episode").toString()).get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"tmpBindFiles\n           \u2026                   .get()");
                File file3 = ((RegularFile)object2).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"tmpBindFiles\n           \u2026                  .asFile");
                FilesKt.copyTo$default((File)file2, (File)file3, (boolean)false, (int)0, (int)6, null);
                continue;
            }
            this.getLogger().warn("Unknown binding file configuration type for " + bindJarFile.getName());
        }
    }

    private final XjcExtension getXjcExtension() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Object object = project.getExtensions().getByName("xjc");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.github.bjornvester.xjc.XjcExtension");
        }
        return (XjcExtension)object;
    }

    @Inject
    public XjcTask(@NotNull WorkerExecutor workerExecutor, @NotNull ObjectFactory objectFactory, @NotNull ProjectLayout projectLayout, @NotNull FileSystemOperations fileSystemOperations) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)projectLayout, (String)"projectLayout");
        Intrinsics.checkNotNullParameter((Object)fileSystemOperations, (String)"fileSystemOperations");
        this.workerExecutor = workerExecutor;
        this.fileSystemOperations = fileSystemOperations;
        Property property = objectFactory.property(String.class).convention((Provider)this.getXjcExtension().getDefaultPackage());
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"objectFactory.property(S\u2026tension().defaultPackage)");
        this.defaultPackage = property;
        DirectoryProperty directoryProperty = objectFactory.directoryProperty().convention((Provider)this.getXjcExtension().getXsdDir());
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objectFactory.directoryP\u2026getXjcExtension().xsdDir)");
        this.xsdDir = directoryProperty;
        this.xsdFiles = this.getXjcExtension().getXsdFiles();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        NamedDomainObjectProvider namedDomainObjectProvider = project.getConfigurations().named("xjc");
        Intrinsics.checkNotNullExpressionValue((Object)namedDomainObjectProvider, (String)"project.configurations.n\u2026n.XJC_CONFIGURATION_NAME)");
        this.xjcConfiguration = namedDomainObjectProvider;
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        NamedDomainObjectProvider namedDomainObjectProvider2 = project2.getConfigurations().named("xjcPlugins");
        Intrinsics.checkNotNullExpressionValue((Object)namedDomainObjectProvider2, (String)"project.configurations.n\u2026UGINS_CONFIGURATION_NAME)");
        this.xjcPluginsConfiguration = namedDomainObjectProvider2;
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        NamedDomainObjectProvider namedDomainObjectProvider3 = project3.getConfigurations().named("xjcBindings");
        Intrinsics.checkNotNullExpressionValue((Object)namedDomainObjectProvider3, (String)"project.configurations.n\u2026_BIND_CONFIGURATION_NAME)");
        this.xjcBindConfiguration = namedDomainObjectProvider3;
        Property property2 = objectFactory.property(Boolean.TYPE).convention((Provider)this.getXjcExtension().getGenerateEpisode());
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"objectFactory.property(B\u2026ension().generateEpisode)");
        this.generateEpisode = property2;
        this.bindingFiles = this.getXjcExtension().getBindingFiles();
        ListProperty listProperty = objectFactory.listProperty(String.class).convention((Provider)this.getXjcExtension().getOptions());
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"objectFactory.listProper\u2026etXjcExtension().options)");
        this.options = listProperty;
        Property property3 = objectFactory.property(Boolean.TYPE).convention((Provider)this.getXjcExtension().getMarkGenerated());
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"objectFactory.property(B\u2026xtension().markGenerated)");
        this.markGenerated = property3;
        DirectoryProperty directoryProperty2 = objectFactory.directoryProperty().convention((Provider)this.getXjcExtension().getOutputJavaDir());
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty2, (String)"objectFactory.directoryP\u2026xtension().outputJavaDir)");
        this.outputJavaDir = directoryProperty2;
        DirectoryProperty directoryProperty3 = objectFactory.directoryProperty().convention((Provider)this.getXjcExtension().getOutputResourcesDir());
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty3, (String)"objectFactory.directoryP\u2026ion().outputResourcesDir)");
        this.outputResourcesDir = directoryProperty3;
        DirectoryProperty directoryProperty4 = objectFactory.directoryProperty().convention(projectLayout.getBuildDirectory().dir("xjc/extracted-bind-files"));
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty4, (String)"objectFactory.directoryP\u2026c/extracted-bind-files\"))");
        this.tmpBindFiles = directoryProperty4;
        this.setGroup("build");
        this.setDescription("Generates Java classes from XSD files.");
    }
}

