/*
 * Decompiled with CFR 0.152.
 */
package com.github.ayltai.gradle.plugin;

import com.github.ayltai.gradle.plugin.SpringGraalNativeExtension;
import com.github.ayltai.gradle.plugin.SpringGraalNativeTask;
import javax.annotation.Nonnull;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;

public class SpringGraalNativePlugin
implements Plugin<Project> {
    static final String CURRENT_TASK = "buildNativeImage";
    static final String DEPENDENT_TASK = "bootJar";
    private static final String DEPENDENT_REPO = "https://repo.spring.io/milestone";
    private static final String DEPENDENT_ARTIFACT = "org.springframework.experimental:spring-graalvm-native:0.7.1";

    public void apply(@Nonnull Project project) {
        project.getRepositories().maven(repo -> repo.setUrl((Object)DEPENDENT_REPO));
        ((Configuration)project.getConfigurations().maybeCreate("implementation")).getDependencies().add((Object)project.getDependencies().create((Object)DEPENDENT_ARTIFACT));
        SpringGraalNativeExtension extension = (SpringGraalNativeExtension)project.getExtensions().create("nativeImage", SpringGraalNativeExtension.class, new Object[]{project.getObjects()});
        project.getTasks().register(CURRENT_TASK, SpringGraalNativeTask.class).configure(task -> {
            task.dependsOn(new Object[]{SpringGraalNativePlugin.getDependency(project)});
            task.traceClassInitialization.set((Object)extension.getTraceClassInitialization());
            task.removeSaturatedTypeFlows.set((Object)extension.getRemoveSaturatedTypeFlows());
            task.reportExceptionStackTraces.set((Object)extension.getReportExceptionStackTraces());
            task.printAnalysisCallTree.set((Object)extension.getPrintAnalysisCallTree());
            task.enabledAllSecurityServices.set((Object)extension.getEnabledAllSecurityServices());
            task.staticallyLinked.set((Object)extension.getStaticallyLinked());
            task.verbose.set((Object)extension.getVerbose());
            task.warnMissingSelectorHints.set((Object)extension.getWarnMissingSelectorHints());
            task.removeUnusedAutoConfig.set((Object)extension.getRemoveUnusedAutoConfig());
            task.removeYamlSupport.set((Object)extension.getRemoveYamlSupport());
            task.removeXmlSupport.set((Object)extension.getRemoveXmlSupport());
            task.removeSpelSupport.set((Object)extension.getRemoveSpelSupport());
            task.removeJmxSupport.set((Object)extension.getRemoveJmxSupport());
            task.verify.set((Object)extension.getVerify());
            task.springNativeVerbose.set((Object)extension.getSpringNativeVerbose());
            task.springNativeMode.set((Object)extension.getSpringNativeMode());
            task.dumpConfig.set((Object)extension.getDumpConfig());
            task.mainClassName.set((Object)extension.getMainClassName());
            task.maxHeapSize.set((Object)extension.getMaxHeapSize());
            task.initializeAtBuildTime.set(extension.getInitializeAtBuildTime());
        });
    }

    @Nonnull
    protected static Task getDependency(@Nonnull Project project) {
        return project.getTasks().getByName(DEPENDENT_TASK);
    }
}

